/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyModule;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.PutInstr;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class PutClassVariableInstr
extends PutInstr
implements FixedArityInstr {
    public PutClassVariableInstr(Operand scope, String varName, Operand value2) {
        super(Operation.PUT_CVAR, scope, varName, value2);
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new PutClassVariableInstr(this.getTarget().cloneForInlining(ii), this.ref, this.getValue().cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        IRubyObject value2 = (IRubyObject)this.getValue().retrieve(context, self2, currScope, currDynScope, temp);
        RubyModule module = (RubyModule)this.getTarget().retrieve(context, self2, currScope, currDynScope, temp);
        assert (module != null) : "MODULE should always be something";
        if (!(this.getValue() instanceof CurrentScope)) {
            module.setClassVar(this.getRef(), value2);
        }
        return null;
    }

    public static PutClassVariableInstr decode(IRReaderDecoder d) {
        return new PutClassVariableInstr(d.decodeOperand(), d.decodeString(), d.decodeOperand());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.PutClassVariableInstr(this);
    }
}

