/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

public class Symbol
extends ImmutableLiteral {
    public static final Symbol KW_REST_ARG_DUMMY = new Symbol("", (Encoding)ASCIIEncoding.INSTANCE);
    private final ByteList bytes;

    public Symbol(String name2, Encoding encoding2) {
        this.bytes = new ByteList(name2.getBytes(EncodingUtils.charsetForEncoding(encoding2)), encoding2);
    }

    public Symbol(ByteList bytes2) {
        this.bytes = bytes2;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Symbol)) {
            return false;
        }
        return this.bytes.equals((Object)((Symbol)other).bytes);
    }

    @Override
    public OperandType getOperandType() {
        return OperandType.SYMBOL;
    }

    public ByteList getBytes() {
        return this.bytes;
    }

    public String getString() {
        return RubyString.byteListToString(this.bytes);
    }

    @Override
    public Object createCacheObject(ThreadContext context) {
        return RubySymbol.newSymbol(context.runtime, this.bytes);
    }

    @Override
    public boolean canCopyPropagate() {
        return true;
    }

    public Encoding getEncoding() {
        return this.bytes.getEncoding();
    }

    public String toString() {
        return ":'" + this.getString() + "'";
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getString());
        e.encode(this.getEncoding());
    }

    public static Symbol decode(IRReaderDecoder d) {
        return new Symbol(d.decodeString(), d.decodeEncoding());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Symbol(this);
    }
}

