/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.viewer.image;

import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawService;
import net.imagej.ui.swing.viewer.image.FigureView;
import net.imagej.ui.swing.viewer.image.JHotDrawImageCanvas;
import net.imagej.ui.swing.viewer.image.SwingImageDisplayViewer;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.event.FigureListener;
import org.scijava.AbstractContextual;
import org.scijava.plugin.Parameter;

public class OverlayFigureView
extends AbstractContextual
implements FigureView {
    private final SwingImageDisplayViewer displayViewer;
    private final OverlayView overlayView;
    private final Figure figure;
    private final JHotDrawAdapter<Figure> adapter;
    @Parameter
    private JHotDrawService jHotDrawService;
    private boolean updatingFigure = false;
    private boolean updatingOverlay = false;

    public OverlayFigureView(SwingImageDisplayViewer displayViewer, OverlayView overlayView) {
        this(displayViewer, overlayView, null);
    }

    public OverlayFigureView(SwingImageDisplayViewer displayViewer, final OverlayView overlayView, Figure figure) {
        this.setContext(displayViewer.getDisplay().getContext());
        this.displayViewer = displayViewer;
        this.overlayView = overlayView;
        JHotDrawAdapter<?> adapterMatch = this.jHotDrawService.getAdapter(overlayView.getData(), figure);
        this.adapter = adapterMatch;
        if (figure == null) {
            this.figure = this.adapter.createDefaultFigure();
            this.adapter.updateFigure(overlayView, this.figure);
            JHotDrawImageCanvas canvas = displayViewer.getCanvas();
            Drawing drawing = canvas.getDrawing();
            drawing.add(this.figure);
        } else {
            this.figure = figure;
        }
        this.figure.addFigureListener((FigureListener)new FigureAdapter(){

            public void attributeChanged(FigureEvent e) {
                if (OverlayFigureView.this.updatingFigure) {
                    return;
                }
                OverlayFigureView.this.updatingOverlay = true;
                try {
                    OverlayFigureView.this.adapter.updateOverlay(OverlayFigureView.this.figure, OverlayFigureView.this.overlayView);
                    overlayView.update();
                }
                finally {
                    OverlayFigureView.this.updatingOverlay = false;
                }
            }

            public void figureChanged(FigureEvent e) {
                if (OverlayFigureView.this.updatingFigure) {
                    return;
                }
                OverlayFigureView.this.updatingOverlay = true;
                try {
                    OverlayFigureView.this.adapter.updateOverlay(OverlayFigureView.this.figure, OverlayFigureView.this.overlayView);
                    overlayView.update();
                }
                finally {
                    OverlayFigureView.this.updatingOverlay = false;
                }
            }

            public void figureRemoved(FigureEvent e) {
                ImageDisplay d = OverlayFigureView.this.getDisplay();
                if (d.isVisible(overlayView)) {
                    DataView view = OverlayFigureView.this.getDataView();
                    d.remove(view);
                    view.dispose();
                    OverlayFigureView.this.dispose();
                    d.update();
                }
            }
        });
    }

    private ImageDisplay getDisplay() {
        ImageDisplay display = this.displayViewer.getDisplay();
        assert (display instanceof ImageDisplay);
        return display;
    }

    private void show(boolean doShow) {
        JHotDrawImageCanvas canvas = this.displayViewer.getCanvas();
        Drawing drawing = canvas.getDrawing();
        Figure fig = this.getFigure();
        if (doShow) {
            if (!drawing.contains(fig)) {
                drawing.add(fig);
            }
        } else if (drawing.contains(fig)) {
            drawing.remove(fig);
        }
    }

    @Override
    public void update() {
        this.updateFigure();
    }

    @Override
    public Figure getFigure() {
        return this.figure;
    }

    @Override
    public void dispose() {
        this.figure.requestRemove();
    }

    private void updateFigure() {
        if (this.updatingOverlay) {
            return;
        }
        this.updatingFigure = true;
        try {
            this.adapter.updateFigure(this.overlayView, this.figure);
            this.show(this.getDisplay().isVisible(this.overlayView));
        }
        finally {
            this.updatingFigure = false;
        }
    }

    @Override
    public DataView getDataView() {
        return this.overlayView;
    }
}

