/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import sc.fiji.coloc.algorithms.Stepper;

public class BisectionStepper
extends Stepper {
    protected double threshold1;
    protected double threshold2;
    protected double thrDiff = Double.NaN;
    protected int iterations = 0;
    protected int maxIterations = 100;

    public BisectionStepper(double threshold, double lastThreshold) {
        this.threshold1 = threshold;
        this.threshold2 = lastThreshold;
        this.thrDiff = Math.abs(this.threshold1 - this.threshold2);
    }

    @Override
    public void update(double value) {
        this.threshold2 = this.threshold1;
        if (Double.NaN == value || value < 0.0) {
            this.threshold1 += this.thrDiff * 0.5;
        } else if (value > 0.0) {
            this.threshold1 -= this.thrDiff * 0.5;
        }
        this.thrDiff = Math.abs(this.threshold1 - this.threshold2);
        ++this.iterations;
    }

    @Override
    public double getValue() {
        return this.threshold1;
    }

    @Override
    public boolean isFinished() {
        return this.iterations > this.maxIterations || this.thrDiff < 1.0;
    }
}

