/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRFunction;
import org.renjin.compiler.ir.tac.IRFunctionTable;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.DynamicCall;
import org.renjin.compiler.ir.tac.expressions.Elipses;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.IRThunk;
import org.renjin.compiler.ir.tac.expressions.LocalVariable;
import org.renjin.compiler.ir.tac.expressions.PrimitiveCall;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.compiler.ir.tac.expressions.Temp;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslators;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.compiler.ir.tac.statements.ReturnStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class IRBodyBuilder {
    private int nextTemp = 0;
    private int nextLocalVariableIndex = 0;
    private int nextLabel = 0;
    private FunctionCallTranslators builders = new FunctionCallTranslators();
    private List<Statement> statements;
    private IRLabel currentLabel;
    private Map<IRLabel, Integer> labels;
    private IRFunctionTable functionTable;
    private List<IRThunk> thunks = Lists.newArrayList();

    public IRBodyBuilder(IRFunctionTable functionTable) {
        this.functionTable = functionTable;
    }

    public IRBody build(SEXP exp2) {
        this.statements = Lists.newArrayList();
        this.labels = Maps.newHashMap();
        TopLevelContext context = new TopLevelContext();
        Expression returnValue = this.translateExpression(context, exp2);
        this.addStatement(new ReturnStatement(returnValue));
        this.removeRedundantJumps();
        return new IRBody(this.statements, this.labels, this.nextTemp);
    }

    public void dump(SEXP exp2) {
        System.out.println(this.build(exp2).toString());
    }

    public Expression translateExpression(TranslationContext context, SEXP exp2) {
        if (exp2 instanceof ExpressionVector) {
            return this.translateExpressionList(context, (ExpressionVector)exp2);
        }
        if (exp2 instanceof Symbol) {
            if (exp2 == Symbol.MISSING_ARG) {
                return new Constant(exp2);
            }
            return new EnvironmentVariable((Symbol)exp2);
        }
        if (exp2 instanceof FunctionCall) {
            return this.translateCall(context, (FunctionCall)exp2);
        }
        return new Constant(exp2);
    }

    private boolean isReservedFunction(SEXP exp2) {
        if (exp2 instanceof FunctionCall) {
            SEXP fn = ((FunctionCall)exp2).getFunction();
            return fn instanceof Symbol && ((Symbol)fn).isReservedWord();
        }
        return false;
    }

    public static boolean isConstant(SEXP exp2) {
        return !(exp2 instanceof ExpressionVector) && !(exp2 instanceof Symbol) && !(exp2 instanceof FunctionCall);
    }

    public void translateStatements(TranslationContext context, SEXP sexp) {
        FunctionCallTranslator translator;
        if (this.isReservedFunction(sexp) && (translator = this.builders.get(((FunctionCall)sexp).getFunction())) != null) {
            translator.addStatement(this, context, (FunctionCall)sexp);
            return;
        }
        Expression expr = this.translateExpression(context, sexp);
        if (!(expr instanceof Constant)) {
            this.addStatement(new ExprStatement(expr));
        }
    }

    public Expression translateCall(TranslationContext context, FunctionCall call2) {
        SEXP function2 = call2.getFunction();
        if (function2 instanceof Symbol && ((Symbol)function2).isReservedWord()) {
            return this.translatePrimitiveCall(context, call2);
        }
        return new DynamicCall(call2, this.translateSimpleExpression(context, function2), this.makeNameList(call2), this.makeUnevaledArgList(context, call2.getArguments()));
    }

    public List<Expression> makeUnevaledArgList(TranslationContext context, PairList argumentSexps) {
        ArrayList list2 = Lists.newArrayList();
        for (SEXP argument : argumentSexps.values()) {
            if (argument == Symbol.MISSING_ARG) {
                list2.add(new Constant(argument));
                continue;
            }
            if (argument == Symbols.ELLIPSES) {
                list2.add(Elipses.INSTANCE);
                continue;
            }
            list2.add(this.unevaledArg(argument));
        }
        return list2;
    }

    public Expression unevaledArg(SEXP exp2) {
        if (IRBodyBuilder.isConstant(exp2)) {
            return new Constant(exp2);
        }
        return this.translateThunk(exp2);
    }

    private IRThunk translateThunk(SEXP exp2) {
        IRBodyBuilder thunkBodyBuilder = new IRBodyBuilder(this.functionTable);
        IRBody body2 = thunkBodyBuilder.build(exp2);
        IRThunk thunk = new IRThunk(exp2, body2);
        this.thunks.add(thunk);
        return thunk;
    }

    public Expression translateSetterCall(TranslationContext context, FunctionCall getterCall, Expression rhs) {
        Symbol getter = (Symbol)getterCall.getFunction();
        Symbol setter = Symbol.get(getter.getPrintName() + "<-");
        FunctionCall setterCall = new FunctionCall(setter, PairList.Node.newBuilder().addAll(getterCall.getArguments()).add("value", (SEXP)new StringArrayVector("TODO: evaluated RHS here")).build());
        FunctionCallTranslator translator = this.builders.get(setter);
        if (translator != null) {
            return translator.translateToSetterExpression(this, context, setterCall, rhs);
        }
        if (setter.isReservedWord()) {
            List<Expression> arguments = this.makeEvaledArgList(context, getterCall.getArguments());
            arguments.add(this.simplify(rhs));
            return new PrimitiveCall(setterCall, setter, arguments);
        }
        List<Expression> arguments = this.makeUnevaledArgList(context, getterCall.getArguments());
        arguments.add(rhs);
        List<SEXP> argumentNames = this.makeNameList(getterCall);
        argumentNames.add(Symbol.get("value"));
        return new DynamicCall(setterCall, new EnvironmentVariable(setter), argumentNames, arguments);
    }

    public Expression translatePrimitiveCall(TranslationContext context, FunctionCall call2) {
        SEXP function2 = call2.getFunction();
        FunctionCallTranslator translator = this.builders.get(function2);
        if (translator != null) {
            return translator.translateToExpression(this, context, call2);
        }
        if (!(function2 instanceof Symbol)) {
            throw new IllegalArgumentException("Expected symbol, got '" + function2 + "'");
        }
        return new PrimitiveCall(call2, (Symbol)function2, this.makeEvaledArgList(context, call2.getArguments()));
    }

    private List<Expression> makeEvaledArgList(TranslationContext context, PairList argumentSexps) {
        ArrayList arguments = Lists.newArrayList();
        for (SEXP arg : argumentSexps.values()) {
            if (arg == Symbols.ELLIPSES) {
                arguments.add(Elipses.INSTANCE);
                continue;
            }
            arguments.add(this.simplify(this.translateExpression(context, arg)));
        }
        return arguments;
    }

    private List<SEXP> makeNameList(FunctionCall call2) {
        ArrayList names2 = Lists.newArrayList();
        for (PairList.Node node : call2.getArguments().nodes()) {
            names2.add(node.getRawTag());
        }
        return names2;
    }

    public SimpleExpression simplify(Expression rvalue) {
        if (rvalue instanceof SimpleExpression) {
            return (SimpleExpression)rvalue;
        }
        Temp temp = this.newTemp();
        this.addStatement(new Assignment(temp, rvalue));
        return temp;
    }

    public SimpleExpression translateSimpleExpression(TranslationContext context, SEXP exp2) {
        return this.simplify(this.translateExpression(context, exp2));
    }

    private Expression translateExpressionList(TranslationContext context, ExpressionVector vector2) {
        if (vector2.length() == 0) {
            return new Constant(Null.INSTANCE);
        }
        int i = 0;
        while (i + 1 < vector2.length()) {
            this.translateStatements(context, vector2.getElementAsSEXP(i));
            ++i;
        }
        return this.translateExpression(context, vector2.getElementAsSEXP(vector2.length() - 1));
    }

    public Temp newTemp() {
        return new Temp(this.nextTemp++);
    }

    public LocalVariable newLocalVariable() {
        return new LocalVariable("\u039b" + this.nextLocalVariableIndex++, this.nextTemp++);
    }

    public IRLabel newLabel() {
        return new IRLabel(this.nextLabel++);
    }

    public IRFunction newFunction(PairList formals2, SEXP body2) {
        return this.functionTable.newFunction(formals2, body2);
    }

    public void addStatement(Statement statement) {
        this.statements.add(statement);
        this.currentLabel = null;
    }

    public IRLabel addLabel() {
        if (this.currentLabel != null) {
            return this.currentLabel;
        }
        IRLabel newLabel = this.newLabel();
        this.addLabel(newLabel);
        return newLabel;
    }

    public void addLabel(IRLabel label) {
        this.labels.put(label, this.statements.size());
        this.currentLabel = label;
    }

    private void removeRedundantJumps() {
        boolean changed;
        do {
            changed = false;
            for (int i = 0; i != this.statements.size(); ++i) {
                IRLabel newFalseTarget;
                Statement stmt = this.statements.get(i);
                if (!(stmt instanceof IfStatement)) continue;
                IfStatement ifStmt = (IfStatement)stmt;
                IRLabel newTrueTarget = this.ultimateTarget(ifStmt.getTrueTarget());
                if (newTrueTarget != null) {
                    this.statements.set(i, ifStmt.setTrueTarget(newTrueTarget));
                    changed = true;
                }
                if ((newFalseTarget = this.ultimateTarget(ifStmt.getFalseTarget())) == null) continue;
                this.statements.set(i, ifStmt.setFalseTarget(newFalseTarget));
                changed = true;
            }
        } while (changed);
    }

    private IRLabel ultimateTarget(IRLabel label) {
        Statement targetStmt = this.statements.get(this.labels.get(label));
        if (targetStmt instanceof GotoStatement) {
            return ((GotoStatement)targetStmt).getTarget();
        }
        return null;
    }

    private static class TopLevelContext
    implements TranslationContext {
        private TopLevelContext() {
        }
    }
}

