/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.derivative;

import java.util.ArrayList;
import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.AllPartialDerivatives.class)
public class PartialDerivativesRAI<T extends RealType<T>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<T>, CompositeIntervalView<T, RealComposite<T>>>
implements Ops.Filter.AllPartialDerivatives {
    private UnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>[] derivativeFunctions;

    @Override
    public void initialize() {
        this.derivativeFunctions = new UnaryFunctionOp[((RandomAccessibleInterval)this.in()).numDimensions()];
        for (int i = 0; i < ((RandomAccessibleInterval)this.in()).numDimensions(); ++i) {
            this.derivativeFunctions[i] = RAIs.function(this.ops(), Ops.Filter.PartialDerivative.class, (RandomAccessibleInterval)this.in(), i);
        }
    }

    @Override
    public CompositeIntervalView<T, RealComposite<T>> calculate(RandomAccessibleInterval<T> input) {
        ArrayList<RandomAccessibleInterval<T>> derivatives = new ArrayList<RandomAccessibleInterval<T>>();
        for (int i = 0; i < this.derivativeFunctions.length; ++i) {
            RandomAccessibleInterval<T> derivative = this.derivativeFunctions[i].calculate(input);
            derivatives.add(derivative);
        }
        RandomAccessibleInterval stacked = Views.stack(derivatives);
        return Views.collapseReal((RandomAccessibleInterval)stacked);
    }
}

