/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom3d.mesh;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.imagej.ops.geom.geom3d.mesh.TriangularFacet;
import net.imglib2.RealLocalizable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;

public class Vertex
extends Vector3D
implements RealLocalizable {
    private static final long serialVersionUID = 1L;
    private double distanceToFaceInFront = 0.0;
    private List<TriangularFacet> facesInFront = new ArrayList<TriangularFacet>();

    public Vertex(double x, double y, double z) {
        super(x, y, z);
    }

    public double getDistanceToFaceInFront() {
        return this.distanceToFaceInFront;
    }

    public void setDistanceToFaceInFront(double m_distanceToFaceInFront) {
        this.distanceToFaceInFront = m_distanceToFaceInFront;
    }

    public void addFaceInFront(TriangularFacet f) {
        this.facesInFront.add(f);
    }

    public void clearFacesInFront() {
        this.facesInFront.clear();
    }

    public List<Vertex> getPointsInFront() {
        Iterator<TriangularFacet> it = this.facesInFront.iterator();
        ArrayList<Vertex> l = new ArrayList<Vertex>();
        while (it.hasNext()) {
            l.addAll(it.next().getVerticesInFront());
        }
        return l;
    }

    public List<TriangularFacet> getFacesInFront() {
        return this.facesInFront;
    }

    public void cleanFaceInFront() {
        this.facesInFront.clear();
    }

    public int numDimensions() {
        return 3;
    }

    public void localize(float[] position) {
        position[0] = this.getFloatPosition(0);
        position[1] = this.getFloatPosition(1);
        position[2] = this.getFloatPosition(2);
    }

    public void localize(double[] position) {
        position[0] = this.getDoublePosition(0);
        position[1] = this.getDoublePosition(1);
        position[2] = this.getDoublePosition(2);
    }

    public float getFloatPosition(int d) {
        switch (d) {
            case 0: {
                return (float)this.getX();
            }
            case 1: {
                return (float)this.getY();
            }
            case 2: {
                return (float)this.getZ();
            }
        }
        return -1.0f;
    }

    public double getDoublePosition(int d) {
        switch (d) {
            case 0: {
                return this.getX();
            }
            case 1: {
                return this.getY();
            }
            case 2: {
                return this.getZ();
            }
        }
        return -1.0;
    }
}

