/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.Variance.class, label="Statistics: Variance", priority=10000.0)
public class IterableVariance<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.Variance {
    @Override
    public void compute(Iterable<I> input, O output) {
        int n = 0;
        double mean = 0.0;
        double M2 = 0.0;
        for (RealType in : input) {
            double x = in.getRealDouble();
            double delta = x - mean;
            M2 += delta * (x - (mean += delta / (double)(++n)));
        }
        if (n < 2) {
            output.setReal(Double.NaN);
        } else {
            output.setReal(M2 / (double)(n - 1));
        }
    }
}

