/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.visitor;

import ij.io.FileSaver;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealTransformRealRandomAccessible;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.thickness.inference.visitor.FileSaverVisitor;
import org.janelia.thickness.lut.LUTRealTransform;
import org.janelia.utility.MatrixStripConversion;

public class MatrixVisitor
extends FileSaverVisitor {
    private final int range;

    public MatrixVisitor(String basePath, String relativeFilePattern, int range) {
        super(basePath, relativeFilePattern);
        this.range = range;
    }

    @Override
    public <T extends RealType<T>> void act(int iteration, RandomAccessibleInterval<T> matrix, RandomAccessibleInterval<T> scaledMatrix, double[] lut, int[] permutation, int[] inversePermutation, double[] multipliers, RandomAccessibleInterval<double[]> estimatedFit) {
        RealType dummy = (RealType)((RealType)scaledMatrix.randomAccess().get()).createVariable();
        dummy.setReal(Double.NaN);
        String path = this.fileDir(iteration);
        if (iteration == 0) {
            this.createParentDirectory(path);
        }
        LUTRealTransform tf = new LUTRealTransform(lut, 2, 2);
        RealTransformRealRandomAccessible transformed = RealViews.transformReal((RealRandomAccessible)Views.interpolate((EuclideanSpace)Views.extendValue(scaledMatrix, (Type)dummy), (InterpolatorFactory)new NLinearInterpolatorFactory()), (InvertibleRealTransform)tf);
        double s = 1.0 / (lut[lut.length - 1] - lut[0]) * (double)lut.length;
        double o = -lut[0];
        ScaleAndTranslation scaleAndTranslation = new ScaleAndTranslation(new double[]{s, s}, new double[]{o, o});
        IntervalView offset = Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)RealViews.transformReal((RealRandomAccessible)transformed, (InvertibleRealTransform)scaleAndTranslation)), scaledMatrix);
        RandomAccessibleInterval<RealType> strip = MatrixStripConversion.matrixToStrip(offset, this.range, dummy);
        new FileSaver(ImageJFunctions.wrap(strip, (String)"")).saveAsTiff(path);
    }
}

