/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.net.ssl.SSLHandshakeException;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import org.scijava.log.LogService;

public class HTTPSUtil {
    private static boolean secureMode = true;
    private static boolean offlineMode = false;
    private static final String secureURL = "https://imagej.net/api.php";
    private static final String insecureUserSiteURL = "http://sites.imagej.net";
    private static final String secureUserSiteURL = "https://sites.imagej.net";

    public static void checkHTTPSSupport(LogService log) {
        offlineMode = false;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(secureURL).openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(10000);
        }
        catch (ProtocolException e) {
            if (log != null) {
                log.error((Throwable)e);
            }
            e.printStackTrace();
        }
        try {
            connection.getResponseCode();
            secureMode = true;
        }
        catch (UnknownHostException e) {
            String msg = "Could not determine the IP address of https://imagej.net. Make sure you are connected to a network.";
            HTTPSUtil.warn(log, msg, e);
            offlineMode = true;
        }
        catch (SSLHandshakeException e) {
            secureMode = false;
            String msg = "Your Java might be too old to handle updates via HTTPS. This is a security risk. Depending on your setup please download a recent version of this software or update your local Java installation.";
            HTTPSUtil.warn(log, msg, e);
        }
        catch (SocketTimeoutException e) {
            secureMode = false;
            String msg = "Timeout while trying to update securely via HTTPS. Will fall back to HTTP. This is a security risk. Please contact your system administrator to enable communication via HTTPS.";
            HTTPSUtil.warn(log, msg, e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void warn(LogService log, String msg, Throwable t) {
        if (log != null) {
            if (log.isDebug()) {
                log.debug((Object)msg, t);
            } else {
                log.warn((Object)msg);
            }
        } else {
            System.out.println("[WARNING] " + msg);
        }
    }

    public static boolean supportsHTTPS() {
        return secureMode;
    }

    public static boolean noConnection() {
        return offlineMode;
    }

    public static String getProtocol() {
        return secureMode ? "https://" : "http://";
    }

    public static String fixImageJUserSiteProtocol(String url) {
        if (!HTTPSUtil.supportsHTTPS() && HTTPSUtil.isHTTPSUserSiteURL(url)) {
            return HTTPSUtil.userSiteConvertToHTTP(url);
        }
        if (HTTPSUtil.supportsHTTPS() && HTTPSUtil.isHTTPUserSiteURL(url)) {
            return HTTPSUtil.userSiteConvertToHTTPS(url);
        }
        return url;
    }

    private static boolean isHTTPUserSiteURL(String url) {
        return url.startsWith(insecureUserSiteURL);
    }

    private static boolean isHTTPSUserSiteURL(String url) {
        return url.startsWith(secureUserSiteURL);
    }

    public static boolean supportsURLProtocol(String url) {
        if (!url.startsWith(secureUserSiteURL)) {
            return true;
        }
        return HTTPSUtil.supportsHTTPS();
    }

    public static String userSiteConvertToHTTP(String url) {
        return url.replace(secureUserSiteURL, insecureUserSiteURL);
    }

    private static String userSiteConvertToHTTPS(String url) {
        return url.replace(insecureUserSiteURL, secureUserSiteURL);
    }

    public static boolean hasImageJUserSiteProtocolUpdates(FilesCollection plugins) {
        if (HTTPSUtil.supportsHTTPS()) {
            for (UpdateSite site : plugins.getUpdateSites(false)) {
                if (!site.getURL().startsWith(insecureUserSiteURL)) continue;
                return true;
            }
        } else {
            for (UpdateSite site : plugins.getUpdateSites(false)) {
                if (!site.getURL().startsWith(secureUserSiteURL)) continue;
                return true;
            }
        }
        return false;
    }
}

