/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.commands.debug;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.app.App;
import org.scijava.app.AppService;
import org.scijava.app.StatusService;
import org.scijava.command.Command;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;
import org.scijava.util.ClassUtils;
import org.scijava.util.Manifest;
import org.scijava.util.POM;

@Plugin(type=Command.class, menuPath="Plugins>Debug>System Information", headless=true)
public class SystemInformation
implements Command {
    private static final String NL = System.getProperty("line.separator");
    @Parameter
    private Context context;
    @Parameter
    private AppService appService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private LogService log;
    @Parameter(label="System Information", type=ItemIO.OUTPUT)
    private String info;

    public void run() {
        this.statusService.showStatus("Gathering system information");
        List poms = POM.getAllPOMs();
        int progress = 0;
        int max = 10 + poms.size();
        this.statusService.showProgress(++progress, max);
        StringBuilder sb = new StringBuilder();
        sb.append(this.appService.getApp().getInfo(false) + NL);
        this.statusService.showProgress(++progress, max);
        Map apps = this.appService.getApps();
        for (Object name : apps.keySet()) {
            App app = (App)apps.get(name);
            Manifest manifest = app.getManifest();
            sb.append(NL);
            sb.append("-- Application: " + (String)name + " --" + NL);
            sb.append("Title = " + app.getTitle() + NL);
            sb.append("Version = " + app.getVersion() + NL);
            sb.append("groupId = " + app.getGroupId() + NL);
            sb.append("artifactId = " + app.getArtifactId() + NL);
            if (manifest == null) continue;
            sb.append(SystemInformation.getManifestData(manifest));
        }
        this.statusService.showProgress(++progress, max);
        HashMap<String, Object> pomsByGA = new HashMap<String, Object>();
        for (Object pom : poms) {
            String ga = pom.getGroupId() + ":" + pom.getArtifactId();
            POM priorPOM = (POM)pomsByGA.get(ga);
            if (priorPOM == null) {
                pomsByGA.put(ga, pom);
                continue;
            }
            sb.append("[WARNING] Version clash for " + ga + ": " + pom.getVersion() + " shadows " + priorPOM.getVersion() + NL);
        }
        this.statusService.showProgress(++progress, max);
        ArrayList sortedPOMs = new ArrayList(poms);
        Collections.sort(sortedPOMs);
        for (POM pom : sortedPOMs) {
            this.statusService.showProgress(++progress, max);
            String pomPath = pom.getPath();
            String groupId = pom.getGroupId();
            String artifactId = pom.getArtifactId();
            String version = pom.getVersion();
            String name = pom.getProjectName();
            String url = pom.getProjectURL();
            String year = pom.getProjectInceptionYear();
            String orgName = pom.getOrganizationName();
            String orgURL = pom.getOrganizationURL();
            String title = name == null ? groupId + ":" + artifactId : name;
            String scmConnection = pom.cdata("//project/scm/connection");
            String scmTag = pom.cdata("//project/scm/tag");
            String sourceRef = null;
            if (scmTag == null || scmTag.isEmpty() || scmTag.equals("HEAD") || scmTag.equals("master")) {
                if (pomPath != null && pomPath.contains(".jar!")) {
                    String jarPath = pomPath.substring(0, pomPath.indexOf("!"));
                    try {
                        URL jarURL = new URL("jar:" + jarPath + "!/");
                        JarURLConnection conn = (JarURLConnection)jarURL.openConnection();
                        String key = "Implementation-Build";
                        sourceRef = conn.getManifest().getMainAttributes().getValue("Implementation-Build");
                    }
                    catch (IOException e) {
                        this.log.debug((Throwable)e);
                    }
                }
            } else {
                sourceRef = scmTag;
            }
            sb.append(NL);
            sb.append("-- Library: " + title + " --" + NL);
            if (pomPath != null) {
                sb.append("path = " + (String)pomPath + NL);
            }
            if (groupId != null) {
                sb.append("groupId = " + groupId + NL);
            }
            if (artifactId != null) {
                sb.append("artifactId = " + artifactId + NL);
            }
            if (version != null) {
                sb.append("version = " + version + NL);
            }
            if (url != null) {
                sb.append("project URL = " + url + NL);
            }
            if (year != null) {
                sb.append("inception year = " + year + NL);
            }
            if (orgName != null) {
                sb.append("organization name = " + orgName + NL);
            }
            if (orgURL != null) {
                sb.append("organization URL = " + orgURL + NL);
            }
            if (scmConnection != null) {
                sb.append("scm = " + scmConnection + NL);
            }
            if (sourceRef == null) continue;
            sb.append("source ref = " + sourceRef + NL);
        }
        this.statusService.showProgress(++progress, max);
        List plugins = this.context.getPluginIndex().getAll();
        HashSet<Class> pluginTypeSet = new HashSet<Class>();
        for (PluginInfo plugin : plugins) {
            pluginTypeSet.add(plugin.getPluginType());
        }
        this.statusService.showProgress(++progress, max);
        ArrayList pluginTypes = new ArrayList(pluginTypeSet);
        Collections.sort(pluginTypes, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return ClassUtils.compare(c1, c2);
            }
        });
        this.statusService.showProgress(++progress, max);
        for (Class pluginType : pluginTypes) {
            this.dumpPlugins(sb, pluginType);
        }
        this.statusService.showProgress(++progress, max);
        sb.append(NL);
        sb.append("-- System properties --" + NL);
        sb.append(SystemInformation.getSystemProperties());
        this.statusService.showProgress(++progress, max);
        sb.append(NL);
        sb.append("-- Environment variables --" + NL);
        sb.append(SystemInformation.getEnvironmentVariables());
        this.statusService.showProgress(++progress, max);
        sb.append(NL);
        sb.append("-- Additional miscellany --" + NL);
        sb.append(SystemInformation.getMiscellany());
        this.statusService.showProgress(++progress, max);
        this.info = sb.toString();
        this.statusService.clearStatus();
    }

    public static String getSystemProperties() {
        return SystemInformation.mapToString(System.getProperties());
    }

    public static String getEnvironmentVariables() {
        return SystemInformation.mapToString(System.getenv());
    }

    public static String getMiscellany() {
        HashMap<String, String> miscellany = new HashMap<String, String>();
        JavaCompiler sjc = ToolProvider.getSystemJavaCompiler();
        miscellany.put("System Java compiler", SystemInformation.classNameAndLocation(sjc));
        ClassLoader stcl = ToolProvider.getSystemToolClassLoader();
        miscellany.put("System tool class loader", SystemInformation.classNameAndLocation(stcl));
        return SystemInformation.mapToString(miscellany);
    }

    public static String getManifestData(Manifest manifest) {
        if (manifest == null) {
            return null;
        }
        return SystemInformation.mapToString(manifest.getAll());
    }

    public static String mapToString(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (Object key : keys) {
            String sValue;
            if (key == null) continue;
            Object value = map.get(key);
            String sKey = key.toString();
            String string = sValue = value == null ? "(null)" : value.toString();
            if (sKey.endsWith(".dirs") || sKey.endsWith(".path")) {
                String[] dirs = sValue.split(Pattern.quote(File.pathSeparator));
                sb.append(sKey + " = {" + NL);
                for (String dir : dirs) {
                    sb.append("\t" + dir + NL);
                }
                sb.append("}" + NL);
                continue;
            }
            sb.append(sKey + " = " + sValue + NL);
        }
        return sb.toString();
    }

    private <PT extends SciJavaPlugin> void dumpPlugins(StringBuilder sb, Class<PT> pluginType) {
        List plugins = this.context.getPluginIndex().getPlugins(pluginType);
        int pluginCount = 0;
        for (PluginInfo plugin : plugins) {
            if (pluginType != plugin.getPluginType()) continue;
            ++pluginCount;
        }
        if (pluginCount == 0) {
            return;
        }
        sb.append(NL);
        sb.append("-- " + pluginCount + " " + pluginType.getName() + " plugins --" + NL);
        for (PluginInfo plugin : plugins) {
            if (pluginType != plugin.getPluginType()) continue;
            sb.append(plugin + NL);
        }
    }

    private static String classNameAndLocation(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        return c.getName() + " [" + ClassUtils.getLocation(c) + "]";
    }
}

