/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.convolve;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.filter.convolve.PadAndConvolveFFT;
import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.Convolve.class, priority=101.0)
public class PadAndConvolveFFTF<I extends RealType<I>, O extends RealType<O> & NativeType<O>, K extends RealType<K>>
extends AbstractBinaryFunctionOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>>
implements Ops.Filter.Convolve,
Contingent {
    @Parameter(required=false)
    private OutOfBoundsFactory<I, RandomAccessibleInterval<I>> obf;
    @Parameter(required=false)
    private O outType;
    private BinaryComputerOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<K>, RandomAccessibleInterval<O>> convolver;

    @Override
    public void initialize() {
        super.initialize();
        this.convolver = Computers.binary(this.ops(), PadAndConvolveFFT.class, RandomAccessibleInterval.class, this.in1(), this.in2(), new Object[]{null, this.obf});
    }

    public RandomAccessibleInterval<O> createOutput(RandomAccessibleInterval<I> input, RandomAccessibleInterval<K> kernel) {
        if (this.outType == null) {
            if (((RealType)Util.getTypeFromInterval(input)).getClass() == ((RealType)Util.getTypeFromInterval(kernel)).getClass()) {
                Type temp = ((RealType)Util.getTypeFromInterval(input)).createVariable();
                this.outType = (RealType)temp;
            } else {
                FloatType temp = new FloatType();
                this.outType = (RealType)temp;
            }
        }
        return this.ops().create().img((Dimensions)input, (NativeType)this.outType.createVariable());
    }

    @Override
    public RandomAccessibleInterval<O> calculate(RandomAccessibleInterval<I> img, RandomAccessibleInterval<K> kernel) {
        RandomAccessibleInterval<O> out = this.createOutput(img, kernel);
        if (this.obf == null) {
            this.obf = new OutOfBoundsConstantValueFactory((Object)((RealType)Util.getTypeFromInterval((Interval)((Interval)this.in()))).createVariable());
        }
        IntervalView extendedIn = Views.interval((RandomAccessible)Views.extend(img, this.obf), img);
        OutOfBoundsConstantValueFactory obfOutput = new OutOfBoundsConstantValueFactory((Object)((RealType)Util.getTypeFromInterval(out)).createVariable());
        IntervalView extendedOut = Views.interval((RandomAccessible)Views.extend(out, (OutOfBoundsFactory)obfOutput), out);
        this.convolver.compute((RandomAccessibleInterval<I>)extendedIn, (RandomAccessibleInterval<IntervalView>)extendedOut);
        return out;
    }

    @Override
    public boolean conforms() {
        return Intervals.numElements((Dimensions)((Dimensions)this.in2())) > 9L;
    }
}

