/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealPoint;
import net.imglib2.concatenate.Concatenable;
import net.imglib2.concatenate.PreConcatenable;
import net.imglib2.realtransform.AbstractScale;
import net.imglib2.realtransform.ScaleGet;

public class Scale
extends AbstractScale
implements Concatenable<ScaleGet>,
PreConcatenable<ScaleGet> {
    protected final Scale inverse;

    protected Scale(double[] s, Scale inverse, RealPoint[] ds) {
        super(s, ds);
        this.inverse = inverse;
    }

    public Scale(double ... s) {
        super((double[])s.clone(), new RealPoint[s.length]);
        double[] si = new double[s.length];
        RealPoint[] dis = new RealPoint[s.length];
        for (int d = 0; d < s.length; ++d) {
            si[d] = 1.0 / s[d];
            RealPoint dd = new RealPoint(s.length);
            dd.setPosition(s[d], d);
            this.ds[d] = dd;
            RealPoint ddi = new RealPoint(s.length);
            ddi.setPosition(si[d], d);
            dis[d] = ddi;
        }
        this.inverse = new Scale(si, this, dis);
    }

    @Override
    public void set(double ... s) {
        for (int d = 0; d < s.length; ++d) {
            this.s[d] = s[d];
            this.inverse.s[d] = 1.0 / s[d];
            this.ds[d].setPosition(s[d], d);
            this.inverse.ds[d].setPosition(this.inverse.s[d], d);
        }
    }

    @Override
    public Scale inverse() {
        return this.inverse;
    }

    @Override
    public Scale copy() {
        return new Scale(this.s);
    }

    public Scale preConcatenate(ScaleGet a) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            int n = d;
            this.s[n] = this.s[n] * a.getScale(d);
        }
        return this;
    }

    public Class<ScaleGet> getPreConcatenableClass() {
        return ScaleGet.class;
    }

    public Scale concatenate(ScaleGet a) {
        return this.preConcatenate(a);
    }

    public Class<ScaleGet> getConcatenableClass() {
        return ScaleGet.class;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.s.length; ++i) {
            if (this.s[i] == 1.0) continue;
            return false;
        }
        return true;
    }
}

