/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.ijsupport.bottle;

import edu.utexas.clm.archipelago.network.MessageXC;
import edu.utexas.clm.archipelago.network.translation.Bottle;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import mpicbg.models.Point;

public class PointBottle
implements Bottle<Point> {
    private static final Map<Long, Point> idPointMap = Collections.synchronizedMap(new HashMap());
    private static final Map<Point, Long> pointIdMap = Collections.synchronizedMap(new IdentityHashMap());
    private static final ReentrantLock idPointLock = new ReentrantLock();
    private static final ReentrantLock idIdLock = new ReentrantLock();
    private static final AtomicLong idGenerator = new AtomicLong(1L);
    private final double[] w;
    private final double[] l;
    private final long id;
    private final boolean fromOrigin;

    private static void mapIdToPoint(Point point, long original) {
        idIdLock.lock();
        pointIdMap.put(point, original);
        idIdLock.unlock();
    }

    private static long getId(Point point, long idDefault) {
        idIdLock.lock();
        Long id = pointIdMap.get(point);
        idIdLock.unlock();
        return id == null ? idDefault : id;
    }

    private static void mapPointToID(long orig, Point point) {
        idPointLock.lock();
        idPointMap.put(orig, point);
        idPointLock.unlock();
    }

    private static boolean existsOrPut(long id, Point point) {
        idPointLock.lock();
        if (idPointMap.containsKey(id)) {
            idPointLock.unlock();
            return true;
        }
        idIdLock.lock();
        idPointMap.put(id, point);
        pointIdMap.put(point, id);
        idIdLock.unlock();
        idPointLock.unlock();
        return false;
    }

    public static Point getPoint(long orig, Point localPoint) {
        idPointLock.lock();
        Point point = idPointMap.get(orig);
        idPointLock.unlock();
        return point == null ? localPoint : point;
    }

    public PointBottle(Point point, boolean isOrigin) {
        int idHash = System.identityHashCode(point);
        this.w = point.getW();
        this.l = point.getL();
        this.fromOrigin = isOrigin;
        if (this.fromOrigin) {
            if (pointIdMap.containsKey(point)) {
                this.id = PointBottle.getId(point, idHash);
            } else {
                this.id = idGenerator.getAndIncrement();
                PointBottle.mapIdToPoint(point, this.id);
                PointBottle.mapPointToID(this.id, point);
            }
        } else {
            this.id = point instanceof IdPoint ? ((IdPoint)point).getID() : -1L;
        }
    }

    public Point unBottle(MessageXC xc) {
        if (this.fromOrigin) {
            IdPoint point = new IdPoint(this.id, new Point(this.l, this.w));
            if (PointBottle.existsOrPut(this.id, point)) {
                return PointBottle.getPoint(this.id, point);
            }
            return point;
        }
        if (this.id >= 0L) {
            Point point = new Point(this.l, this.w);
            Point origPoint = PointBottle.getPoint(this.id, point);
            PointBottle.syncPoint(origPoint, point);
            return origPoint;
        }
        return new Point(this.l, this.w);
    }

    private static synchronized void syncPoint(Point to, Point from) {
        if (from != null && to != from) {
            int j;
            double[] wTo = to.getW();
            double[] wFrom = from.getW();
            double[] lTo = to.getL();
            double[] lFrom = from.getL();
            for (j = 0; j < wTo.length; ++j) {
                wTo[j] = wFrom[j];
            }
            for (j = 0; j < lTo.length; ++j) {
                lTo[j] = lFrom[j];
            }
        }
    }

    public class IdPoint
    extends Point {
        private final long id;

        public IdPoint(long id, Point pt) {
            super(pt.getL(), pt.getW());
            this.id = id;
        }

        public long getID() {
            return this.id;
        }
    }
}

