/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Tensors2;
import edu.mines.jtk.dsp.Tensors3;
import edu.mines.jtk.util.Parallel;

public class LocalLaplacianFilter {
    private float _scale;

    public LocalLaplacianFilter() {
        this(1.0);
    }

    public LocalLaplacianFilter(double scale) {
        this._scale = (float)scale;
    }

    public void apply(Tensors2 d, float[][] x, float[][] y) {
        float[] di = new float[3];
        int n1 = x[0].length;
        int n2 = x.length;
        for (int i2 = 1; i2 < n2; ++i2) {
            for (int i1 = 1; i1 < n1; ++i1) {
                d.getTensor(i1, i2, di);
                float d11 = di[0] * this._scale;
                float d12 = di[1] * this._scale;
                float d22 = di[2] * this._scale;
                float x00 = x[i2][i1];
                float x01 = x[i2][i1 - 1];
                float x10 = x[i2 - 1][i1];
                float x11 = x[i2 - 1][i1 - 1];
                float xa = x00 - x11;
                float xb = x01 - x10;
                float x1 = 0.5f * (xa - xb);
                float x2 = 0.5f * (xa + xb);
                float y1 = d11 * x1 + d12 * x2;
                float y2 = d12 * x1 + d22 * x2;
                float ya = 0.5f * (y1 + y2);
                float yb = 0.5f * (y1 - y2);
                float[] fArray = y[i2];
                int n = i1;
                fArray[n] = fArray[n] + ya;
                float[] fArray2 = y[i2];
                int n3 = i1 - 1;
                fArray2[n3] = fArray2[n3] - yb;
                float[] fArray3 = y[i2 - 1];
                int n4 = i1;
                fArray3[n4] = fArray3[n4] + yb;
                float[] fArray4 = y[i2 - 1];
                int n5 = i1 - 1;
                fArray4[n5] = fArray4[n5] - ya;
            }
        }
    }

    public void apply(Tensors3 d, float[][][] x, float[][][] y) {
        this.applyParallel(d, x, y);
    }

    private void applyParallel(final Tensors3 d, final float[][][] x, final float[][][] y) {
        int n3 = x.length;
        Parallel.loop(1, n3, 2, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                LocalLaplacianFilter.this.applySlice3(i3, d, x, y);
            }
        });
        Parallel.loop(2, n3, 2, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                LocalLaplacianFilter.this.applySlice3(i3, d, x, y);
            }
        });
    }

    private void applySlice3(int i3, Tensors3 d, float[][][] x, float[][][] y) {
        float[] di = new float[6];
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        for (int i2 = 1; i2 < n2; ++i2) {
            float[] x00 = x[i3][i2];
            float[] x01 = x[i3][i2 - 1];
            float[] x10 = x[i3 - 1][i2];
            float[] x11 = x[i3 - 1][i2 - 1];
            float[] y00 = y[i3][i2];
            float[] y01 = y[i3][i2 - 1];
            float[] y10 = y[i3 - 1][i2];
            float[] y11 = y[i3 - 1][i2 - 1];
            int i1 = 1;
            int i1m = 0;
            while (i1 < n1) {
                d.getTensor(i1, i2, i3, di);
                float d11 = di[0] * this._scale;
                float d12 = di[1] * this._scale;
                float d13 = di[2] * this._scale;
                float d22 = di[3] * this._scale;
                float d23 = di[4] * this._scale;
                float d33 = di[5] * this._scale;
                LocalLaplacianFilter.apply(i1, d11, d12, d13, d22, d23, d33, x00, x01, x10, x11, y00, y01, y10, y11);
                ++i1;
                ++i1m;
            }
        }
    }

    private static void apply(int i1, float d11, float d12, float d13, float d22, float d23, float d33, float[] x00, float[] x01, float[] x10, float[] x11, float[] y00, float[] y01, float[] y10, float[] y11) {
        int i1m = i1 - 1;
        float x000 = x00[i1];
        float x001 = x00[i1m];
        float x010 = x01[i1];
        float x100 = x10[i1];
        float x011 = x01[i1m];
        float x101 = x10[i1m];
        float x110 = x11[i1];
        float x111 = x11[i1m];
        float xa = x000 - x111;
        float xb = x001 - x110;
        float xc = x010 - x101;
        float xd = x100 - x011;
        float x1 = 0.25f * (xa - xb + xc + xd);
        float x2 = 0.25f * (xa + xb - xc + xd);
        float x3 = 0.25f * (xa + xb + xc - xd);
        float y1 = d11 * x1 + d12 * x2 + d13 * x3;
        float y2 = d12 * x1 + d22 * x2 + d23 * x3;
        float y3 = d13 * x1 + d23 * x2 + d33 * x3;
        float ya = 0.25f * (y1 + y2 + y3);
        float yb = 0.25f * (y1 - y2 + y3);
        float yc = 0.25f * (y1 + y2 - y3);
        float yd = 0.25f * (y1 - y2 - y3);
        int n = i1;
        y00[n] = y00[n] + ya;
        int n2 = i1m;
        y00[n2] = y00[n2] - yd;
        int n3 = i1;
        y01[n3] = y01[n3] + yb;
        int n4 = i1;
        y10[n4] = y10[n4] + yc;
        int n5 = i1m;
        y01[n5] = y01[n5] - yc;
        int n6 = i1m;
        y10[n6] = y10[n6] - yb;
        int n7 = i1;
        y11[n7] = y11[n7] + yd;
        int n8 = i1m;
        y11[n8] = y11[n8] - ya;
    }
}

