/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.util.Axis;

class AxisShufflingVertexReader
implements ElementReader {
    private final ElementReader reader;
    private final Axis xAxis;
    private final Axis yAxis;
    private final Axis zAxis;

    public AxisShufflingVertexReader(ElementReader reader, Axis x, Axis y, Axis z) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null");
        }
        if (x == null) {
            throw new NullPointerException("x must not be null.");
        }
        if (y == null) {
            throw new NullPointerException("y must not be null.");
        }
        if (z == null) {
            throw new NullPointerException("z must not be null.");
        }
        if (!"vertex".equals(reader.getElementType().getName())) {
            throw new IllegalArgumentException("This class can only be used on vertex readers.");
        }
        this.reader = reader;
        this.xAxis = x;
        this.yAxis = y;
        this.zAxis = z;
    }

    @Override
    public ElementType getElementType() {
        return this.reader.getElementType();
    }

    @Override
    public int getCount() {
        return this.reader.getCount();
    }

    @Override
    public Element readElement() throws IOException {
        Element element = this.reader.readElement();
        if (element == null) {
            return null;
        }
        double x = element.getDouble("x");
        double y = element.getDouble("y");
        double z = element.getDouble("z");
        element = element.clone();
        element.setDouble("x", this.getValue(x, y, z, this.xAxis));
        element.setDouble("y", this.getValue(x, y, z, this.yAxis));
        element.setDouble("z", this.getValue(x, y, z, this.zAxis));
        return element;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean isClosed() {
        return this.reader.isClosed();
    }

    private double getValue(double x, double y, double z, Axis axis) {
        switch (axis) {
            case X: {
                return x;
            }
            case X_INVERTED: {
                return -x;
            }
            case Y: {
                return y;
            }
            case Y_INVERTED: {
                return -y;
            }
            case Z: {
                return z;
            }
            case Z_INVERTED: {
                return -z;
            }
        }
        throw new IllegalArgumentException("Unsupported axis.");
    }
}

