/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.io.FileInfo;
import ij.io.FileOpener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.zip.InflaterInputStream;

class ExtendedFileOpener
extends FileOpener {
    public ExtendedFileOpener(FileInfo fi) {
        super(fi);
    }

    public InputStream createInputStream(FileInfo fi) throws IOException, MalformedURLException {
        InputStream is = super.createInputStream(fi);
        if (is != null && fi.fileName.toLowerCase().endsWith(".zraw")) {
            return new InflaterInputStream(is);
        }
        if (is != null && fi.fileName.toLowerCase().endsWith(".mha")) {
            String line = "";
            long bc = 0L;
            do {
                int c;
                line = "";
                do {
                    if ((c = is.read()) < 0) {
                        IJ.error((String)("Header ended unexpectedly! Aborting at byte: " + bc));
                        System.exit(1);
                    }
                    ++bc;
                    line = line + (char)c;
                } while (c != 10);
            } while (!line.startsWith("ElementDataFile"));
            return new InflaterInputStream(is);
        }
        return is;
    }
}

