/*
 * Decompiled with CFR 0.152.
 */
package textureByRef;

import ij.IJ;
import ij.ImageJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import ij3d.Image3DUniverse;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.ColoringAttributes;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.ImageComponent;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PolygonAttributes;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.RenderingAttributes;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.Texture2D;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.utils.pickfast.PickCanvas;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector4f;

public class Texture_By_Ref
implements PlugInFilter,
ImageListener,
MouseMotionListener,
MouseListener {
    private static final int TEX_MODE = 1;
    private static final int COMP_TYPE = 10;
    private static final boolean BY_REF = true;
    private static final boolean Y_UP = true;
    private Image3DUniverse univ;
    private ByteProcessor bProcessor;
    private ImageComponent2D bComp;
    private ImageComponent2D.Updater updater;
    private ImagePlus imp;
    private int w = 256;
    private int h = 256;
    private static final int r = 5;
    private boolean doDraw = false;

    public static void main(String[] args) {
        new ImageJ();
        ImagePlus img = IJ.openImage((String)"/home/bene/PhD/brains/template.tif");
        img = new ImagePlus("Slice 20", img.getStack().getProcessor(20));
        img.show();
        IJ.runPlugIn((String)"textureByRef.Texture_By_Ref", (String)"");
    }

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 1;
    }

    public void run(ImageProcessor ip) {
        if (this.imp.getStackSize() > 1 || !Texture_By_Ref.isPow2(this.imp.getWidth()) || !Texture_By_Ref.isPow2(this.imp.getHeight())) {
            IJ.error((String)"Only one slice allowed, whose dimensions must be a power of 2");
            return;
        }
        this.createImage();
        this.univ = new Image3DUniverse();
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)this.createShape());
        bg.compile();
        this.univ.getScene().addChild((Node)bg);
        this.univ.show();
        this.univ.getCanvas().addMouseListener((MouseListener)this);
        this.univ.getCanvas().addMouseMotionListener((MouseMotionListener)this);
        this.updater = new ImageUpdater();
        ImagePlus.addImageListener((ImageListener)this);
        this.imp.show();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.doDraw) {
            return;
        }
        OvalRoi roi = new OvalRoi(e.getX() - 5, e.getY() - 5, 10, 10);
        Polygon p = roi.getPolygon();
        int n = p.npoints;
        Polygon q = new Polygon(new int[n], new int[n], n);
        for (int i = 0; i < n; ++i) {
            Point3d picked = this.getPickPoint(p.xpoints[i], p.ypoints[i]);
            if (picked == null) continue;
            q.xpoints[i] = (int)Math.round(picked.x);
            q.ypoints[i] = (int)Math.round(picked.y);
        }
        this.bProcessor.fillPolygon(q);
        this.imp.updateAndDraw();
    }

    private final Point3d getPickPoint(int x, int y) {
        PickCanvas pickCanvas = new PickCanvas(this.univ.getCanvas(), this.univ.getScene());
        pickCanvas.setMode(2);
        pickCanvas.setFlags(8);
        pickCanvas.setTolerance(3.0f);
        pickCanvas.setShapeLocation(x, y);
        try {
            PickInfo[] result = pickCanvas.pickAllSorted();
            if (result == null || result.length == 0) {
                return null;
            }
            int i = 0;
            if (i < result.length) {
                return result[i].getClosestIntersectionPoint();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int id = Toolbar.getToolId();
        this.doDraw = id == 10 || id == 15 || id == 16 || id == 17 || id == 18 || id == 19 || id == 20 || id == 21 || id == 22;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void imageOpened(ImagePlus image) {
    }

    public void imageClosed(ImagePlus image) {
    }

    public void imageUpdated(ImagePlus image) {
        if (image == this.imp) {
            this.bComp.updateData(this.updater, 0, 0, this.w, this.h);
        }
    }

    public Appearance createAppearance() {
        Appearance appearance = new Appearance();
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(6);
        texAttr.setCombineRgbMode(1);
        texAttr.setPerspectiveCorrectionMode(1);
        appearance.setTextureAttributes(texAttr);
        TransparencyAttributes transAttr = new TransparencyAttributes();
        transAttr.setTransparency(0.1f);
        transAttr.setCapability(3);
        transAttr.setTransparencyMode(2);
        appearance.setTransparencyAttributes(transAttr);
        PolygonAttributes polyAttr = new PolygonAttributes();
        polyAttr.setCullFace(0);
        appearance.setPolygonAttributes(polyAttr);
        Material material = new Material();
        material.setLightingEnable(false);
        appearance.setMaterial(material);
        ColoringAttributes colAttr = new ColoringAttributes();
        colAttr.setCapability(1);
        colAttr.setShadeModel(1);
        colAttr.setColor(1.0f, 1.0f, 1.0f);
        appearance.setColoringAttributes(colAttr);
        RenderingAttributes rendAttr = new RenderingAttributes();
        rendAttr.setCapability(1);
        rendAttr.setAlphaTestValue(0.1f);
        rendAttr.setAlphaTestFunction(6);
        appearance.setRenderingAttributes(rendAttr);
        appearance.setTexture(this.getTexture());
        appearance.setTexCoordGeneration(this.getTg());
        return appearance;
    }

    public Shape3D createShape() {
        Shape3D shape = new Shape3D((Geometry)this.createGeometry(), this.createAppearance());
        return shape;
    }

    public BufferedImage createImage() {
        this.bProcessor = (ByteProcessor)this.imp.getProcessor();
        byte[] pixels = (byte[])this.bProcessor.getPixels();
        IndexColorModel cm = Texture_By_Ref.getDefaultColorModel();
        SampleModel sm = cm.createCompatibleSampleModel(this.w, this.h);
        DataBufferByte db = new DataBufferByte(pixels, this.w * this.h, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(cm, raster, false, null);
    }

    private static IndexColorModel getDefaultColorModel() {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            r[i] = (byte)i;
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public Texture getTexture() {
        Texture2D tex = new Texture2D(1, 1, this.w, this.h);
        this.bComp = new ImageComponent2D(10, this.w, this.h, true, true);
        this.bComp.setCapability(3);
        this.bComp.set(this.createImage());
        tex.setImage(0, (ImageComponent)this.bComp);
        tex.setEnable(true);
        tex.setMinFilter(3);
        tex.setMagFilter(3);
        tex.setBoundaryModeS(2);
        tex.setBoundaryModeT(2);
        return tex;
    }

    public TexCoordGeneration getTg() {
        float xTexGenScale = (float)(1.0 / (double)this.w);
        float yTexGenScale = (float)(1.0 / (double)this.h);
        TexCoordGeneration tg = new TexCoordGeneration();
        tg.setPlaneS(new Vector4f(xTexGenScale, 0.0f, 0.0f, 0.0f));
        tg.setPlaneT(new Vector4f(0.0f, yTexGenScale, 0.0f, 0.0f));
        return tg;
    }

    public GeometryArray createGeometry() {
        QuadArray quadArray = new QuadArray(4, 5);
        Point3f[] coords = new Point3f[]{new Point3f(0.0f, 0.0f, 0.0f), new Point3f((float)this.w, 0.0f, 0.0f), new Point3f((float)this.w, (float)this.h, 0.0f), new Point3f(0.0f, (float)this.h, 0.0f)};
        Color3f[] colors = new Color3f[]{new Color3f(100.0f, 100.0f, 100.0f), new Color3f(100.0f, 100.0f, 100.0f), new Color3f(100.0f, 100.0f, 100.0f), new Color3f(100.0f, 100.0f, 100.0f)};
        quadArray.setCoordinates(0, coords);
        quadArray.setColors(0, colors);
        return quadArray;
    }

    private static final int nextPow2(int n) {
        int retval;
        for (retval = 2; retval < n; retval <<= 1) {
        }
        return retval;
    }

    private static final boolean isPow2(int n) {
        int next = Texture_By_Ref.nextPow2(n);
        return n == next;
    }

    private class ImageUpdater
    implements ImageComponent2D.Updater {
        private ImageUpdater() {
        }

        public void updateData(ImageComponent2D comp, int x, int y, int w, int h) {
        }
    }
}

