/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.measure.Calibration;
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;

class ShellsCanvas
extends ImageCanvas {
    private ImagePlus imagePlus;
    private double x_spacing;
    private double y_spacing;
    private double z_spacing;
    private double centre_x;
    private double centre_y;
    private double centre_z;
    private int width;
    private int height;
    private int depth;
    private ArrayList<Double> radii;

    public ShellsCanvas(ImagePlus imagePlus, double centre_x, double centre_y, double centre_z) {
        super(imagePlus);
        this.imagePlus = imagePlus;
        this.centre_x = centre_x;
        this.centre_y = centre_y;
        this.centre_z = centre_z;
        System.out.println("Creating canvas with shells centred around: " + centre_x + "," + centre_y + "," + centre_z);
        this.radii = new ArrayList();
        Calibration c = imagePlus.getCalibration();
        this.x_spacing = c.pixelWidth;
        this.y_spacing = c.pixelHeight;
        this.z_spacing = c.pixelDepth;
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
        this.depth = imagePlus.getStackSize();
    }

    public void addRadius(double radius) {
        System.out.println("Added radius: " + radius);
        this.radii.add(new Double(radius));
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawOverlay(g);
    }

    public void drawOverlay(Graphics g) {
        g.setColor(Color.RED);
        int real_side = (int)Math.ceil(this.getMagnification());
        int z = this.imp.getCurrentSlice() - 1;
        for (int shell = 0; shell < this.radii.size(); ++shell) {
            double radius = this.radii.get(shell);
            double real_z = this.z_spacing * (double)z;
            double z_diff = real_z - this.centre_z;
            double a = radius * radius - z_diff * z_diff;
            double a_root = Math.sqrt(a);
            double x_min = (this.centre_x - a_root) / this.x_spacing;
            double x_max = (this.centre_x + a_root) / this.x_spacing;
            double y_min = (this.centre_y - a_root) / this.y_spacing;
            double y_max = (this.centre_y + a_root) / this.y_spacing;
            int x_min_screen = this.screenX((int)Math.round(x_min));
            int x_max_screen = this.screenX((int)Math.round(x_max));
            int y_min_screen = this.screenY((int)Math.round(y_min));
            int y_max_screen = this.screenY((int)Math.round(y_max));
            g.drawOval(x_min_screen, y_min_screen, x_max_screen - x_min_screen, y_max_screen - y_min_screen);
        }
    }
}

