/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.ConversionException;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;

public class ObjectOfASpecificClassConverter
implements Converter<Object> {
    private Class clazz;

    public ObjectOfASpecificClassConverter(Class clazz) {
        this.clazz = clazz;
    }

    @Override
    public SEXP convertToR(Object value) {
        if (value == null) {
            return Null.INSTANCE;
        }
        return new ExternalPtr<Object>(value);
    }

    @Override
    public Object convertToJava(SEXP exp2) {
        ExternalPtr ptr;
        if (exp2 instanceof ExternalPtr && this.clazz.isAssignableFrom((ptr = (ExternalPtr)exp2).getInstance().getClass())) {
            return ptr.getInstance();
        }
        throw new ConversionException();
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        try {
            this.convertToJava(exp2);
            return true;
        }
        catch (ConversionException e) {
            return false;
        }
    }

    @Override
    public int getSpecificity() {
        return 10;
    }
}

