/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;

public class Contexts {
    private Contexts() {
    }

    @Internal(value="sys.nframe")
    public static int sysFrameCount(@Current Context context) {
        return Contexts.findStartingContext(context).getFrameDepth();
    }

    @Internal(value="parent.frame")
    public static Environment parentFrame(@Current Context context, int n) {
        if (n < 1) {
            throw new EvalException("invalid 'n' value", new Object[0]);
        }
        Context cptr = context;
        Environment t2 = cptr.getCallingEnvironment();
        while (!cptr.isTopLevel()) {
            if (cptr.getType() == Context.Type.FUNCTION && cptr.getEnvironment() == t2) {
                if (n == 1) {
                    return cptr.getCallingEnvironment();
                }
                --n;
                t2 = cptr.getCallingEnvironment();
            }
            cptr = cptr.getParent();
        }
        return context.getGlobalEnvironment();
    }

    private static int R_sysparent(int n, Context cptr) {
        if (n <= 0) {
            throw new EvalException("only positive values of 'n' are allowed", new Object[0]);
        }
        while (!cptr.isTopLevel() && n > 1) {
            if (cptr.getType() == Context.Type.FUNCTION) {
                --n;
            }
            cptr = cptr.getParent();
        }
        while (!cptr.isTopLevel() && cptr.getType() != Context.Type.FUNCTION) {
            cptr = cptr.getParent();
        }
        Environment s = cptr.getCallingEnvironment();
        if (s == cptr.getGlobalEnvironment()) {
            return 0;
        }
        int j = 0;
        while (true) {
            if (cptr.getType() == Context.Type.FUNCTION) {
                ++j;
                if (cptr.getEnvironment() == s) {
                    n = j;
                }
            }
            if (cptr.isTopLevel()) break;
            cptr = cptr.getParent();
        }
        n = j - n + 1;
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static Closure R_sysfunction(int n, Context cptr) {
        if ((n = n > 0 ? cptr.getFrameDepth() - n : -n) < 0) {
            throw new EvalException("not that many frames on the stack", new Object[0]);
        }
        while (!cptr.isTopLevel()) {
            if (cptr.getType() == Context.Type.FUNCTION) {
                if (n == 0) {
                    return cptr.getClosure();
                }
                --n;
            }
            cptr = cptr.getParent();
        }
        if (n == 0 && cptr.isTopLevel()) {
            return cptr.getClosure();
        }
        throw new EvalException("not that many frames on the stack", new Object[0]);
    }

    private static Environment R_sysframe(int n, Context cptr) {
        if (n == 0) {
            return cptr.getGlobalEnvironment();
        }
        if ((n = n > 0 ? cptr.getFrameDepth() - n : -n) < 0) {
            throw new EvalException("not that many frames on the stack", new Object[0]);
        }
        while (!cptr.isTopLevel()) {
            if (cptr.getType() == Context.Type.FUNCTION) {
                if (n == 0) {
                    return cptr.getEnvironment();
                }
                --n;
            }
            cptr = cptr.getParent();
        }
        if (n == 0 && cptr.isTopLevel()) {
            return cptr.getGlobalEnvironment();
        }
        throw new EvalException("not that many frames on the stack", new Object[0]);
    }

    private static FunctionCall R_syscall(int n, Context cptr) {
        if ((n = n > 0 ? cptr.getFrameDepth() - n : -n) < 0) {
            throw new EvalException("not that many frames on the stack", new Object[0]);
        }
        while (!cptr.isTopLevel()) {
            if (cptr.getType() == Context.Type.FUNCTION) {
                if (n == 0) {
                    return cptr.getCall();
                }
                --n;
            }
            cptr = cptr.getParent();
        }
        if (n == 0 && cptr.isTopLevel()) {
            return cptr.getCall();
        }
        throw new EvalException("not that many frames on the stack", new Object[0]);
    }

    @Internal(value="sys.parent")
    public static int sysParent(@Current Context context, int n) {
        int nframe2;
        Context cptr = Contexts.findStartingContext(context);
        int i = nframe2 = cptr.getFrameDepth();
        while (n-- > 0) {
            i = Contexts.R_sysparent(nframe2 - i + 1, cptr);
        }
        return i;
    }

    public static Context findStartingContext(Context context) {
        Context cptr = context;
        Environment t2 = cptr.getCallingEnvironment();
        while (!(cptr.isTopLevel() || cptr.getType() == Context.Type.FUNCTION && cptr.getEnvironment() == t2)) {
            cptr = cptr.getParent();
        }
        return cptr;
    }

    @Internal(value="sys.frame")
    public static Environment sysFrame(@Current Context context, int which2) {
        return Contexts.R_sysframe(which2, Contexts.findStartingContext(context));
    }

    @Internal(value="sys.call")
    public static FunctionCall sysCall(@Current Context context, int which2) {
        return Contexts.R_syscall(which2, Contexts.findStartingContext(context));
    }

    @Internal(value="sys.calls")
    public static PairList sysCalls(@Current Context context) {
        Context current = Contexts.findStartingContext(context);
        AbstractSEXP head = Null.INSTANCE;
        while (!current.isTopLevel()) {
            if (current.getCall() != null) {
                head = new PairList.Node(current.getCall(), (PairList)((Object)head));
            }
            current = current.getParent();
        }
        return head;
    }

    @Internal(value="sys.function")
    public static Function sysFunction(@Current Context context, int which2) {
        return Contexts.R_sysfunction(which2, Contexts.findStartingContext(context));
    }
}

