/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.NoSuchElementException;

final class HDF5NaturalBlock1DParameters {
    private final int naturalBlockSize;
    private final long numberOfBlocks;
    private final int lastBlockSize;

    HDF5NaturalBlock1DParameters(HDF5DataSetInformation info) {
        if (info.getRank() > 1) {
            throw new HDF5JavaException("Data Set is expected to be of rank 1 (rank=" + info.getRank() + ")");
        }
        long size = info.getDimensions()[0];
        this.naturalBlockSize = info.getStorageLayout() == HDF5StorageLayout.CHUNKED ? info.tryGetChunkSizes()[0] : (int)size;
        int sizeModNaturalBlockSize = (int)(size % (long)this.naturalBlockSize);
        this.numberOfBlocks = size / (long)this.naturalBlockSize + (long)(sizeModNaturalBlockSize != 0 ? 1 : 0);
        this.lastBlockSize = sizeModNaturalBlockSize != 0 ? sizeModNaturalBlockSize : this.naturalBlockSize;
    }

    HDF5NaturalBlock1DIndex getNaturalBlockIndex() {
        return new HDF5NaturalBlock1DIndex();
    }

    final class HDF5NaturalBlock1DIndex {
        private long index = 0L;
        private long offset;
        private int blockSize;

        HDF5NaturalBlock1DIndex() {
        }

        boolean hasNext() {
            return this.index < HDF5NaturalBlock1DParameters.this.numberOfBlocks;
        }

        long computeOffsetAndSizeGetOffset() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.offset = (long)HDF5NaturalBlock1DParameters.this.naturalBlockSize * this.index;
            this.blockSize = this.index == HDF5NaturalBlock1DParameters.this.numberOfBlocks - 1L ? HDF5NaturalBlock1DParameters.this.lastBlockSize : HDF5NaturalBlock1DParameters.this.naturalBlockSize;
            return this.offset;
        }

        int getBlockSize() {
            return this.blockSize;
        }

        long getAndIncIndex() {
            return this.index++;
        }
    }
}

