/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.TransformList;
import mpicbg.util.Util;

public class InvertibleCoordinateTransformList<E extends InvertibleCoordinateTransform>
implements InvertibleBoundable,
TransformList<E> {
    private static final long serialVersionUID = 2139051181642287413L;
    protected final List<E> transforms = new ArrayList();

    @Override
    public void add(E t) {
        this.transforms.add(t);
    }

    @Override
    public void remove(E t) {
        this.transforms.remove(t);
    }

    @Override
    public E remove(int i) {
        return (E)((InvertibleCoordinateTransform)this.transforms.remove(i));
    }

    @Override
    public E get(int i) {
        return (E)((InvertibleCoordinateTransform)this.transforms.get(i));
    }

    @Override
    public final void clear() {
        this.transforms.clear();
    }

    @Override
    public final List<E> getList(List<E> preAllocatedList) {
        ArrayList<E> returnList = preAllocatedList == null ? new ArrayList<E>() : preAllocatedList;
        returnList.addAll(this.transforms);
        return returnList;
    }

    @Override
    public final double[] apply(double[] location) {
        double[] a = (double[])location.clone();
        this.applyInPlace(a);
        return a;
    }

    @Override
    public final void applyInPlace(double[] location) {
        for (InvertibleCoordinateTransform t : this.transforms) {
            t.applyInPlace(location);
        }
    }

    @Override
    public final double[] applyInverse(double[] location) throws NoninvertibleModelException {
        double[] a = (double[])location.clone();
        this.applyInverseInPlace(a);
        return a;
    }

    @Override
    public final void applyInverseInPlace(double[] location) throws NoninvertibleModelException {
        ListIterator<E> i = this.transforms.listIterator(this.transforms.size());
        while (i.hasPrevious()) {
            ((InvertibleCoordinateTransform)i.previous()).applyInverseInPlace(location);
        }
    }

    @Override
    public void estimateBounds(double[] min, double[] max) {
        assert (min.length == max.length) : "min and max have to have equal length.";
        int g = 32;
        double[] minBounds = new double[min.length];
        double[] maxBounds = new double[min.length];
        double[] s = new double[min.length];
        int[] i = new int[min.length];
        double[] l = new double[min.length];
        for (int k = 0; k < min.length; ++k) {
            minBounds[k] = Double.MAX_VALUE;
            maxBounds[k] = -1.7976931348623157E308;
            s[k] = (max[k] - min[k]) / 31.0;
            l[k] = min[k];
        }
        long d = Util.pow(32, min.length);
        block1: for (long j = 0L; j < d; ++j) {
            int k;
            double[] m = this.apply(l);
            for (k = 0; k < min.length; ++k) {
                if (m[k] < minBounds[k]) {
                    minBounds[k] = m[k];
                }
                if (!(m[k] > maxBounds[k])) continue;
                maxBounds[k] = m[k];
            }
            for (k = 0; k < min.length; ++k) {
                int n = k;
                i[n] = i[n] + 1;
                if (i[k] < 32) {
                    l[k] = min[k] + (double)i[k] * s[k];
                    continue block1;
                }
                i[k] = 0;
                l[k] = min[k];
            }
        }
        for (int k = 0; k < min.length; ++k) {
            min[k] = minBounds[k];
            max[k] = maxBounds[k];
        }
    }

    @Override
    public void estimateInverseBounds(double[] min, double[] max) throws NoninvertibleModelException {
        assert (min.length == max.length) : "min and max have to have equal length.";
        int g = 32;
        double[] minBounds = new double[min.length];
        double[] maxBounds = new double[min.length];
        double[] s = new double[min.length];
        int[] i = new int[min.length];
        double[] l = new double[min.length];
        for (int k = 0; k < min.length; ++k) {
            minBounds[k] = Double.MAX_VALUE;
            maxBounds[k] = -1.7976931348623157E308;
            s[k] = (max[k] - min[k]) / 31.0;
            l[k] = min[k];
        }
        long d = Util.pow(32, min.length);
        block1: for (long j = 0L; j < d; ++j) {
            int k;
            double[] m = this.applyInverse(l);
            for (k = 0; k < min.length; ++k) {
                if (m[k] < minBounds[k]) {
                    minBounds[k] = m[k];
                }
                if (!(m[k] > maxBounds[k])) continue;
                maxBounds[k] = m[k];
            }
            for (k = 0; k < min.length; ++k) {
                int n = k;
                i[n] = i[n] + 1;
                if (i[k] < 32) {
                    l[k] = min[k] + (double)i[k] * s[k];
                    continue block1;
                }
                i[k] = 0;
                l[k] = min[k];
            }
        }
        for (int k = 0; k < min.length; ++k) {
            min[k] = minBounds[k];
            max[k] = maxBounds[k];
        }
    }

    @Override
    public InvertibleCoordinateTransformList<E> createInverse() {
        InvertibleCoordinateTransformList<InvertibleCoordinateTransform> ict = new InvertibleCoordinateTransformList<InvertibleCoordinateTransform>();
        ListIterator<E> i = this.transforms.listIterator(this.transforms.size());
        while (i.hasPrevious()) {
            ict.add(((InvertibleCoordinateTransform)i.previous()).createInverse());
        }
        return ict;
    }
}

