/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class FilterManifest
extends ByteArrayInputStream {
    protected static Set<String> skip = new HashSet<String>();

    public FilterManifest(InputStream in) throws IOException {
        this(in, true);
    }

    public FilterManifest(InputStream in, boolean keepOnlyMainClass) throws IOException {
        super(FilterManifest.filter(in, keepOnlyMainClass));
    }

    protected static byte[] filter(InputStream in, boolean keepOnlyMainClass) throws IOException {
        return FilterManifest.filter(new BufferedReader(new InputStreamReader(in)), keepOnlyMainClass);
    }

    protected static byte[] filter(BufferedReader reader, boolean keepOnlyMainClass) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (keepOnlyMainClass) {
                if (!line.toUpperCase().startsWith("Main-Class:")) continue;
                builder.append(line).append('\n');
                continue;
            }
            int colon = line.indexOf(58);
            if (colon > 0 && skip.contains(line.substring(0, colon).toUpperCase())) continue;
            builder.append(line).append('\n');
        }
        reader.close();
        return builder.toString().getBytes();
    }

    static {
        for (Skip s : Skip.values()) {
            skip.add(s.toString().toUpperCase().replace('_', '-'));
        }
    }

    protected static enum Skip {
        ARCHIVER_VERSION,
        BUILT_BY,
        BUILD_JDK,
        CLASS_PATH,
        CREATED_BY,
        IMPLEMENTATION_BUILD;

    }
}

