/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array3D;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.cursor.array.ArrayLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class Array3DLocalizableByDimCursor<T extends Type<T>>
extends ArrayLocalizableByDimCursor<T>
implements LocalizableByDimCursor3D<T> {
    protected int x = -1;
    protected int y = 0;
    protected int z = 0;
    final int widthMinus1;
    final int heightMinus1;
    final int depthMinus1;
    final int width;
    final int height;
    final int depth;
    final int stepY;
    final int stepZ;
    final Array3D<T, ?> container;

    public Array3DLocalizableByDimCursor(Array3D<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
        this.container = container;
        this.width = container.getWidth();
        this.height = container.getHeight();
        this.depth = container.getDepth();
        this.widthMinus1 = this.width - 1;
        this.heightMinus1 = this.height - 1;
        this.depthMinus1 = this.depth - 1;
        this.stepY = container.getWidth();
        this.stepZ = container.getWidth() * container.getHeight();
        this.reset();
    }

    @Override
    public void fwd() {
        this.type.incIndex();
        if (this.x < this.widthMinus1) {
            ++this.x;
        } else if (this.y < this.heightMinus1) {
            this.x = 0;
            ++this.y;
        } else {
            this.x = 0;
            this.y = 0;
            ++this.z;
        }
    }

    @Override
    public void fwd(long steps) {
        if (steps <= 0L) {
            return;
        }
        this.type.incIndex((int)steps);
        int i = this.type.getIndex();
        this.z = i / (this.width * this.height);
        this.y = (i -= this.z * this.width * this.height) / this.width;
        this.x = i -= this.y * this.width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public void reset() {
        this.isClosed = false;
        this.x = -1;
        this.z = 0;
        this.y = 0;
        this.type.updateIndex(-1);
        this.type.updateContainer(this);
    }

    @Override
    public void getPosition(int[] position) {
        position[0] = this.x;
        position[1] = this.y;
        position[2] = this.z;
    }

    @Override
    public Array3D<T, ?> getStorageContainer() {
        return this.container;
    }

    @Override
    public int[] getPosition() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public int getPosition(int dim) {
        if (dim == 0) {
            return this.x;
        }
        if (dim == 1) {
            return this.y;
        }
        if (dim == 2) {
            return this.z;
        }
        System.err.println("Array3DLocalizableByDimCursor.getPosition( int dim ): There is no dimension " + dim);
        return -1;
    }

    @Override
    public void fwd(int dim) {
        if (dim == 0) {
            this.fwdX();
        } else if (dim == 1) {
            this.fwdY();
        } else if (dim == 2) {
            this.fwdZ();
        } else {
            System.err.println("Array3DLocalizableByDimCursor.fwd( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public void fwdX() {
        this.type.incIndex();
        ++this.x;
    }

    @Override
    public void fwdY() {
        this.type.incIndex(this.stepY);
        ++this.y;
    }

    @Override
    public void fwdZ() {
        this.type.incIndex(this.stepZ);
        ++this.z;
    }

    @Override
    public void move(int steps, int dim) {
        if (dim == 0) {
            this.moveX(steps);
        } else if (dim == 1) {
            this.moveY(steps);
        } else if (dim == 2) {
            this.moveZ(steps);
        } else {
            System.err.println("Array3DLocalizableByDimCursor.move( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public void moveRel(int x, int y, int z) {
        this.moveX(x);
        this.moveY(y);
        this.moveZ(z);
    }

    @Override
    public void moveTo(int x, int y, int z) {
        this.moveX(x - this.x);
        this.moveY(y - this.y);
        this.moveZ(z - this.z);
    }

    @Override
    public void moveX(int steps) {
        this.type.incIndex(steps);
        this.x += steps;
    }

    @Override
    public void moveY(int steps) {
        this.type.incIndex(steps * this.stepY);
        this.y += steps;
    }

    @Override
    public void moveZ(int steps) {
        this.type.incIndex(steps * this.stepZ);
        this.z += steps;
    }

    @Override
    public void bck(int dim) {
        if (dim == 0) {
            this.bckX();
        } else if (dim == 1) {
            this.bckY();
        } else if (dim == 2) {
            this.bckZ();
        } else {
            System.err.println("Array3DLocalizableByDimCursor.bck( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public void bckX() {
        this.type.decIndex();
        --this.x;
    }

    @Override
    public void bckY() {
        this.type.decIndex(this.stepY);
        --this.y;
    }

    @Override
    public void bckZ() {
        this.type.decIndex(this.stepZ);
        --this.z;
    }

    @Override
    public void setPosition(int[] position) {
        this.setPosition(position[0], position[1], position[2]);
    }

    @Override
    public void setPosition(int posX, int posY, int posZ) {
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.type.updateIndex(this.container.getPos(this.x, this.y, this.z));
    }

    @Override
    public void setPositionX(int pos) {
        this.type.incIndex(pos - this.x);
        this.x = pos;
    }

    @Override
    public void setPositionY(int pos) {
        this.type.incIndex((pos - this.y) * this.stepY);
        this.y = pos;
    }

    @Override
    public void setPositionZ(int pos) {
        this.type.incIndex((pos - this.z) * this.stepZ);
        this.z = pos;
    }

    @Override
    public void setPosition(int position, int dim) {
        if (dim == 0) {
            this.setPositionX(position);
        } else if (dim == 1) {
            this.setPositionY(position);
        } else if (dim == 2) {
            this.setPositionZ(position);
        } else {
            System.err.println("Array3DLocalizableByDimCursor.setPosition( int dim ): There is no dimension " + dim);
        }
    }

    @Override
    public String getPositionAsString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }
}

