/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type.numeric.integer;

import mpicbg.imglib.container.DirectAccessContainer;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.basictypecontainer.ByteAccess;
import mpicbg.imglib.type.numeric.integer.GenericByteType;
import mpicbg.imglib.util.Util;

public class UnsignedByteType
extends GenericByteType<UnsignedByteType> {
    public UnsignedByteType(DirectAccessContainer<UnsignedByteType, ? extends ByteAccess> byteStorage) {
        super(byteStorage);
    }

    public UnsignedByteType(int value) {
        super(UnsignedByteType.getCodedSignedByteChecked(value));
    }

    public UnsignedByteType() {
        this(0);
    }

    public static byte getCodedSignedByteChecked(int unsignedByte) {
        if (unsignedByte < 0) {
            unsignedByte = 0;
        } else if (unsignedByte > 255) {
            unsignedByte = 255;
        }
        return UnsignedByteType.getCodedSignedByte(unsignedByte);
    }

    public static byte getCodedSignedByte(int unsignedByte) {
        return (byte)(unsignedByte & 0xFF);
    }

    public static int getUnsignedByte(byte signedByte) {
        return signedByte & 0xFF;
    }

    @Override
    public DirectAccessContainer<UnsignedByteType, ? extends ByteAccess> createSuitableDirectAccessContainer(DirectAccessContainerFactory storageFactory, int[] dim) {
        DirectAccessContainer<UnsignedByteType, ByteAccess> container = storageFactory.createByteInstance(dim, 1);
        UnsignedByteType linkedType = new UnsignedByteType((DirectAccessContainer<UnsignedByteType, ? extends ByteAccess>)container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public UnsignedByteType duplicateTypeOnSameDirectAccessContainer() {
        return new UnsignedByteType(this.storage);
    }

    @Override
    public void mul(float c) {
        int a = UnsignedByteType.getUnsignedByte(this.getValue());
        this.setValue(UnsignedByteType.getCodedSignedByte(Util.round((float)a * c)));
    }

    @Override
    public void mul(double c) {
        int a = UnsignedByteType.getUnsignedByte(this.getValue());
        this.setValue(UnsignedByteType.getCodedSignedByte((int)Util.round((double)a * c)));
    }

    public int get() {
        return UnsignedByteType.getUnsignedByte(this.getValue());
    }

    @Override
    public void set(int f) {
        this.setValue(UnsignedByteType.getCodedSignedByte(f));
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set((int)f);
    }

    @Override
    public double getMaxValue() {
        return 255.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public void div(UnsignedByteType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public int compareTo(UnsignedByteType c) {
        int b;
        int a = this.get();
        if (a > (b = c.get())) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public UnsignedByteType[] createArray1D(int size1) {
        return new UnsignedByteType[size1];
    }

    public UnsignedByteType[][] createArray2D(int size1, int size2) {
        return new UnsignedByteType[size1][size2];
    }

    public UnsignedByteType[][][] createArray3D(int size1, int size2, int size3) {
        return new UnsignedByteType[size1][size2][size3];
    }

    @Override
    public UnsignedByteType createVariable() {
        return new UnsignedByteType(0);
    }

    @Override
    public UnsignedByteType copy() {
        return new UnsignedByteType(this.get());
    }
}

