/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.execution;

import java.util.Arrays;
import java.util.List;
import net.imglib2.Localizable;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.type.numeric.RealType;

public class Power<O extends RealType<O>>
implements OFunction<O> {
    private final OFunction<O> a;
    private final OFunction<O> b;
    private final O scrap;

    public Power(O scrap, OFunction<O> a, OFunction<O> b) {
        this.scrap = scrap;
        this.a = a;
        this.b = b;
    }

    @Override
    public final O eval() {
        this.scrap.set(this.a.eval());
        this.scrap.pow(this.b.eval());
        return this.scrap;
    }

    @Override
    public final O eval(Localizable loc) {
        this.scrap.set(this.a.eval(loc));
        this.scrap.pow(this.b.eval(loc));
        return this.scrap;
    }

    @Override
    public List<OFunction<O>> children() {
        return Arrays.asList(this.a, this.b);
    }

    @Override
    public final double evalDouble() {
        return Math.pow(this.a.evalDouble(), this.b.evalDouble());
    }

    @Override
    public final double evalDouble(Localizable loc) {
        return Math.pow(this.a.evalDouble(loc), this.b.evalDouble(loc));
    }
}

