/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.algorithm.math.ImageStatistics;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Accumulator;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.AutoThresholdRegression;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.gadgets.MaskFactory;
import sc.fiji.coloc.gadgets.ThresholdMode;
import sc.fiji.coloc.results.ResultHandler;

public class PearsonsCorrelation<T extends RealType<T>>
extends Algorithm<T> {
    Implementation theImplementation = Implementation.Fast;
    double pearsonsCorrelationValue;
    double pearsonsCorrelationValueBelowThr;
    double pearsonsCorrelationValueAboveThr;

    public PearsonsCorrelation(Implementation implementation) {
        super("Pearson correlation");
        this.theImplementation = implementation;
    }

    public PearsonsCorrelation() {
        this(Implementation.Fast);
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        RandomAccessibleInterval<T> img1 = container.getSourceImage1();
        RandomAccessibleInterval<T> img2 = container.getSourceImage2();
        RandomAccessibleInterval<BitType> mask = container.getMask();
        AutoThresholdRegression<T> autoThreshold = container.getAutoThreshold();
        if (autoThreshold == null) {
            throw new MissingPreconditionException("Pearsons calculation need AutoThresholdRegression to be run before it.");
        }
        T threshold1 = autoThreshold.getCh1MaxThreshold();
        T threshold2 = autoThreshold.getCh2MaxThreshold();
        if (threshold1 == null || threshold2 == null) {
            throw new MissingPreconditionException("Pearsons calculation needs valid (not null) thresholds.");
        }
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        MissingPreconditionException error = null;
        if (this.theImplementation == Implementation.Classic) {
            double ch1Mean = container.getMeanCh1();
            double ch2Mean = container.getMeanCh2();
            try {
                cursor.reset();
                this.pearsonsCorrelationValue = PearsonsCorrelation.classicPearsons(cursor, ch1Mean, ch2Mean);
            }
            catch (MissingPreconditionException e) {
                this.pearsonsCorrelationValue = Double.NaN;
                error = e;
            }
            try {
                cursor.reset();
                this.pearsonsCorrelationValueBelowThr = PearsonsCorrelation.classicPearsons(cursor, ch1Mean, ch2Mean, threshold1, threshold2, ThresholdMode.Below);
            }
            catch (MissingPreconditionException e) {
                this.pearsonsCorrelationValueBelowThr = Double.NaN;
                error = e;
            }
            try {
                cursor.reset();
                this.pearsonsCorrelationValueAboveThr = PearsonsCorrelation.classicPearsons(cursor, ch1Mean, ch2Mean, threshold1, threshold2, ThresholdMode.Above);
            }
            catch (MissingPreconditionException e) {
                this.pearsonsCorrelationValueAboveThr = Double.NaN;
                error = e;
            }
        } else if (this.theImplementation == Implementation.Fast) {
            try {
                cursor.reset();
                this.pearsonsCorrelationValue = PearsonsCorrelation.fastPearsons(cursor);
            }
            catch (MissingPreconditionException e) {
                this.pearsonsCorrelationValue = Double.NaN;
                error = e;
            }
            try {
                cursor.reset();
                this.pearsonsCorrelationValueBelowThr = PearsonsCorrelation.fastPearsons(cursor, threshold1, threshold2, ThresholdMode.Below);
            }
            catch (MissingPreconditionException e) {
                this.pearsonsCorrelationValueBelowThr = Double.NaN;
                error = e;
            }
            try {
                cursor.reset();
                this.pearsonsCorrelationValueAboveThr = PearsonsCorrelation.fastPearsons(cursor, threshold1, threshold2, ThresholdMode.Above);
            }
            catch (MissingPreconditionException e) {
                this.pearsonsCorrelationValueAboveThr = Double.NaN;
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
    }

    public <S extends RealType<S>> double calculatePearsons(RandomAccessibleInterval<S> img1, RandomAccessibleInterval<S> img2) throws MissingPreconditionException {
        long[] dims = new long[img1.numDimensions()];
        img1.dimensions(dims);
        RandomAccessibleInterval<BitType> alwaysTrueMask = MaskFactory.createMask(dims, true);
        return this.calculatePearsons(img1, img2, alwaysTrueMask);
    }

    public <S extends RealType<S>> double calculatePearsons(RandomAccessibleInterval<S> img1, RandomAccessibleInterval<S> img2, RandomAccessibleInterval<BitType> mask) throws MissingPreconditionException {
        double r;
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        if (this.theImplementation == Implementation.Classic) {
            double mean1 = ImageStatistics.getImageMean(img1);
            double mean2 = ImageStatistics.getImageMean(img2);
            r = PearsonsCorrelation.classicPearsons(cursor, mean1, mean2);
        } else {
            r = PearsonsCorrelation.fastPearsons(cursor);
        }
        return r;
    }

    public <S extends RealType<S>> double calculatePearsons(TwinCursor<S> cursor, double mean1, double mean2, S thresholdCh1, S thresholdCh2, ThresholdMode tMode) throws MissingPreconditionException {
        if (this.theImplementation == Implementation.Classic) {
            return PearsonsCorrelation.classicPearsons(cursor, mean1, mean2, thresholdCh1, thresholdCh2, tMode);
        }
        return PearsonsCorrelation.fastPearsons(cursor, thresholdCh1, thresholdCh2, tMode);
    }

    public static <T extends RealType<T>> double classicPearsons(TwinCursor<T> cursor, double meanCh1, double meanCh2) throws MissingPreconditionException {
        return PearsonsCorrelation.classicPearsons(cursor, meanCh1, meanCh2, null, null, ThresholdMode.None);
    }

    public static <T extends RealType<T>> double classicPearsons(TwinCursor<T> cursor, double meanCh1, double meanCh2, final T thresholdCh1, final T thresholdCh2, ThresholdMode tMode) throws MissingPreconditionException {
        Accumulator acc;
        if (tMode == ThresholdMode.None) {
            acc = new Accumulator<T>((TwinCursor)cursor, meanCh1, meanCh2){

                @Override
                public final boolean accept(T type1, T type2) {
                    return true;
                }
            };
        } else if (tMode == ThresholdMode.Below) {
            acc = new Accumulator<T>(cursor, meanCh1, meanCh2){

                @Override
                public final boolean accept(T type1, T type2) {
                    return type1.compareTo((Object)thresholdCh1) < 0 || type2.compareTo((Object)thresholdCh2) < 0;
                }
            };
        } else if (tMode == ThresholdMode.Above) {
            acc = new Accumulator<T>(cursor, meanCh1, meanCh2){

                @Override
                public final boolean accept(T type1, T type2) {
                    return type1.compareTo((Object)thresholdCh1) > 0 || type2.compareTo((Object)thresholdCh2) > 0;
                }
            };
        } else {
            throw new UnsupportedOperationException();
        }
        double pearsonsR = acc.xy / Math.sqrt(acc.xx * acc.yy);
        PearsonsCorrelation.checkForSanity(pearsonsR, acc.count);
        return pearsonsR;
    }

    public static <T extends RealType<T>> double fastPearsons(TwinCursor<T> cursor) throws MissingPreconditionException {
        return PearsonsCorrelation.fastPearsons(cursor, null, null, ThresholdMode.None);
    }

    public static <T extends RealType<T>> double fastPearsons(TwinCursor<T> cursor, final T thresholdCh1, final T thresholdCh2, ThresholdMode tMode) throws MissingPreconditionException {
        Accumulator acc;
        if (tMode == ThresholdMode.None) {
            acc = new Accumulator<T>((TwinCursor)cursor){

                @Override
                public final boolean accept(T type1, T type2) {
                    return true;
                }
            };
        } else if (tMode == ThresholdMode.Below) {
            acc = new Accumulator<T>(cursor){

                @Override
                public final boolean accept(T type1, T type2) {
                    return type1.compareTo((Object)thresholdCh1) < 0 || type2.compareTo((Object)thresholdCh2) < 0;
                }
            };
        } else if (tMode == ThresholdMode.Above) {
            acc = new Accumulator<T>(cursor){

                @Override
                public final boolean accept(T type1, T type2) {
                    return type1.compareTo((Object)thresholdCh1) > 0 || type2.compareTo((Object)thresholdCh2) > 0;
                }
            };
        } else {
            throw new UnsupportedOperationException();
        }
        double invCount = 1.0 / (double)acc.count;
        double pearsons1 = acc.xy - acc.x * acc.y * invCount;
        double pearsons2 = acc.xx - acc.x * acc.x * invCount;
        double pearsons3 = acc.yy - acc.y * acc.y * invCount;
        double pearsonsR = pearsons1 / Math.sqrt(pearsons2 * pearsons3);
        PearsonsCorrelation.checkForSanity(pearsonsR, acc.count);
        return pearsonsR;
    }

    private static void checkForSanity(double value, int iterations) throws MissingPreconditionException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new MissingPreconditionException("A numerical problem occured: the input data is unsuitable for this algorithm. Possibly too few pixels (in range were: " + iterations + ").");
        }
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        handler.handleValue("Pearson's R value (no threshold)", this.pearsonsCorrelationValue, 2);
        handler.handleValue("Pearson's R value (below threshold)", this.pearsonsCorrelationValueBelowThr, 2);
        handler.handleValue("Pearson's R value (above threshold)", this.pearsonsCorrelationValueAboveThr, 2);
    }

    public double getPearsonsCorrelationValue() {
        return this.pearsonsCorrelationValue;
    }

    public double getPearsonsCorrelationBelowThreshold() {
        return this.pearsonsCorrelationValueBelowThr;
    }

    public double getPearsonsCorrelationAboveThreshold() {
        return this.pearsonsCorrelationValueAboveThr;
    }

    public static enum Implementation {
        Classic,
        Fast;

    }
}

