/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBox;
import spim.process.fusion.boundingbox.AutomaticBoundingBox;
import spim.process.fusion.boundingbox.AutomaticReorientation;
import spim.process.fusion.boundingbox.BigDataViewerBoundingBox;
import spim.process.fusion.boundingbox.BoundingBoxGUI;

public class Define_Bounding_Box
implements PlugIn {
    public static ArrayList<BoundingBoxGUI> staticBoundingBoxAlgorithms = new ArrayList();
    public static int defaultBoundingBoxAlgorithm = 1;
    public static String defaultName = "My Bounding Box";

    public void run(String arg0) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("bounding box definition", true, true, true, true)) {
            return;
        }
        this.defineBoundingBox((SpimData2)((Object)result.getData()), SpimData2.getAllViewIdsSorted((SpimData)result.getData(), result.getViewSetupsToProcess(), result.getTimePointsToProcess()), result.getClusterExtension(), result.getXMLFileName(), true);
    }

    public BoundingBox defineBoundingBox(SpimData2 data, List<ViewId> viewIds) {
        return this.defineBoundingBox(data, viewIds, "", null, false);
    }

    public BoundingBox defineBoundingBox(SpimData2 data, List<ViewId> viewIds, String clusterExtension, String xmlFileName, boolean saveXML) {
        String[] boundingBoxDescriptions = new String[staticBoundingBoxAlgorithms.size()];
        for (int i = 0; i < staticBoundingBoxAlgorithms.size(); ++i) {
            boundingBoxDescriptions[i] = staticBoundingBoxAlgorithms.get(i).getDescription();
        }
        if (defaultBoundingBoxAlgorithm >= boundingBoxDescriptions.length) {
            defaultBoundingBoxAlgorithm = 0;
        }
        GenericDialog gd = new GenericDialog("Image Fusion");
        gd.addChoice("Bounding_Box", boundingBoxDescriptions, boundingBoxDescriptions[defaultBoundingBoxAlgorithm]);
        gd.addStringField("Bounding_Box_Name", defaultName, 30);
        HashMap<String, Integer> names = GUIHelper.assembleRegistrationNames(data, viewIds);
        gd.addMessage("");
        GUIHelper.displayRegistrationNames(gd, names);
        gd.addMessage("");
        GUIHelper.addWebsite(gd);
        if (names.keySet().size() > 5) {
            GUIHelper.addScrollBars((Container)gd);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        int boundingBoxAlgorithm = defaultBoundingBoxAlgorithm = gd.getNextChoiceIndex();
        String boundingBoxName = gd.getNextString();
        for (BoundingBox bb : data.getBoundingBoxes().getBoundingBoxes()) {
            if (!bb.getTitle().equals(boundingBoxName)) continue;
            IOFunctions.println("A bounding box with the name '" + boundingBoxName + "' already exists.");
            defaultName = boundingBoxName + "1";
            return null;
        }
        BoundingBoxGUI boundingBox = staticBoundingBoxAlgorithms.get(boundingBoxAlgorithm).newInstance(data, viewIds);
        if (!boundingBox.queryParameters(null, null)) {
            return null;
        }
        boundingBox.setTitle(boundingBoxName);
        defaultName = boundingBoxName + "1";
        data.getBoundingBoxes().addBoundingBox(boundingBox);
        if (saveXML) {
            SpimData2.saveXML(data, xmlFileName, clusterExtension);
        }
        return boundingBox;
    }

    public static void main(String[] args) {
        LoadParseQueryXML.defaultXMLfilename = "/Users/preibischs/Documents/Microscopy/SPIM/HisYFP-SPIM//dataset.xml";
        new ImageJ();
        new Define_Bounding_Box().run(null);
    }

    static {
        IOFunctions.printIJLog = true;
        staticBoundingBoxAlgorithms.add(new BoundingBoxGUI(null, null));
        staticBoundingBoxAlgorithms.add(new BigDataViewerBoundingBox(null, null));
        staticBoundingBoxAlgorithms.add(new AutomaticReorientation(null, null));
        staticBoundingBoxAlgorithms.add(new AutomaticBoundingBox(null, null));
    }
}

