/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.popup;

import bdv.AbstractSpimSource;
import bdv.BigDataViewer;
import bdv.export.ProgressWriter;
import bdv.tools.InitializeViewerState;
import bdv.tools.brightness.SetupAssignments;
import bdv.tools.transformation.TransformedSource;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.Source;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerPanel;
import bdv.viewer.state.SourceState;
import bdv.viewer.state.ViewerState;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;
import spim.fiji.plugin.apply.BigDataViewerTransformationWindow;
import spim.fiji.spimdata.explorer.ViewSetupExplorerPanel;
import spim.fiji.spimdata.explorer.popup.ViewExplorerSetable;
import spim.fiji.spimdata.imgloaders.AbstractImgLoader;
import spim.fiji.spimdata.imgloaders.StackImgLoader;

public class BDVPopup
extends JMenuItem
implements ViewExplorerSetable {
    private static final long serialVersionUID = 5234649267634013390L;
    public ViewSetupExplorerPanel<?, ?> panel;
    public BigDataViewer bdv = null;

    public BDVPopup() {
        super("Display in BigDataViewer (on/off)");
        this.addActionListener(new MyActionListener());
    }

    public JMenuItem setViewExplorer(ViewSetupExplorerPanel<?, ?> panel) {
        this.panel = panel;
        return this;
    }

    public static boolean bdvRunning() {
        BDVPopup p = ViewSetupExplorerPanel.bdvPopup();
        return p != null && p.bdv != null && p.bdv.getViewerFrame().isVisible();
    }

    public static BigDataViewer createBDV(ViewSetupExplorerPanel<?, ?> panel) {
        BasicImgLoader il = panel.getSpimData().getSequenceDescription().getImgLoader();
        if ((AbstractImgLoader.class.isInstance(il) || StackImgLoader.class.isInstance(il)) && JOptionPane.showConfirmDialog(null, "Opening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.\nProceed anyways?", "Warning", 0) == 1) {
            return null;
        }
        BigDataViewer bdv = BigDataViewer.open(panel.getSpimData(), (String)panel.xml(), (ProgressWriter)IOFunctions.getProgressWriter(), (ViewerOptions)ViewerOptions.options());
        InitializeViewerState.initBrightness((double)0.001, (double)0.999, (AbstractViewerPanel)bdv.getViewer(), (SetupAssignments)bdv.getSetupAssignments());
        BDVPopup.initTransform(bdv.getViewer());
        ViewSetupExplorerPanel.updateBDV(bdv, panel.colorMode(), panel.getSpimData(), panel.firstSelectedVD(), panel.selectedRows());
        return bdv;
    }

    public void updateBDV() {
        if (this.bdv == null) {
            return;
        }
        for (ViewRegistration r : this.panel.getSpimData().getViewRegistrations().getViewRegistrationsOrdered()) {
            r.updateModel();
        }
        ViewerPanel viewerPanel = this.bdv.getViewer();
        ViewerState viewerState = viewerPanel.getState();
        List sources = viewerState.getSources();
        for (SourceState state : sources) {
            int tpi;
            AbstractSpimSource s;
            Source source = state.getSpimSource();
            while (TransformedSource.class.isInstance(source)) {
                source = ((TransformedSource)source).getWrappedSource();
            }
            if (AbstractSpimSource.class.isInstance(source)) {
                s = (AbstractSpimSource)source;
                tpi = BDVPopup.getCurrentTimePointIndex(s);
                BDVPopup.callLoadTimePoint(s, tpi);
            }
            if (state.asVolatile() == null) continue;
            source = state.asVolatile().getSpimSource();
            while (TransformedSource.class.isInstance(source)) {
                source = ((TransformedSource)source).getWrappedSource();
            }
            if (!AbstractSpimSource.class.isInstance(source)) continue;
            s = (AbstractSpimSource)source;
            tpi = BDVPopup.getCurrentTimePointIndex(s);
            BDVPopup.callLoadTimePoint(s, tpi);
        }
        this.bdv.getViewer().requestRepaint();
    }

    public static void initTransform(ViewerPanel viewer) {
        Dimension dim = viewer.getDisplay().getSize();
        ViewerState state = viewer.getState();
        AffineTransform3D viewerTransform = BDVPopup.initTransform(dim.width, dim.height, false, state);
        viewer.setCurrentViewerTransform(viewerTransform);
    }

    public static AffineTransform3D initTransform(int viewerWidth, int viewerHeight, boolean zoomedIn, ViewerState state) {
        int timepoint;
        int cX = viewerWidth / 2;
        int cY = viewerHeight / 2;
        Source source = ((SourceState)state.getSources().get(state.getCurrentSource())).getSpimSource();
        if (!source.isPresent(timepoint = state.getCurrentTimepoint())) {
            return new AffineTransform3D();
        }
        AffineTransform3D sourceTransform = new AffineTransform3D();
        source.getSourceTransform(timepoint, 0, sourceTransform);
        RandomAccessibleInterval sourceInterval = source.getSource(timepoint, 0);
        double sX0 = sourceInterval.min(0);
        double sX1 = sourceInterval.max(0);
        double sY0 = sourceInterval.min(1);
        double sY1 = sourceInterval.max(1);
        double sZ0 = sourceInterval.min(2);
        double sZ1 = sourceInterval.max(2);
        double sX = (sX0 + sX1 + 1.0) / 2.0;
        double sY = (sY0 + sY1 + 1.0) / 2.0;
        double sZ = (sZ0 + sZ1 + 1.0) / 2.0;
        double[][] m = new double[3][4];
        double[] qViewer = new double[]{1.0, 0.0, 0.0, 0.0};
        LinAlgHelpers.quaternionToR((double[])qViewer, (double[][])m);
        double[] centerSource = new double[]{sX, sY, sZ};
        double[] centerGlobal = new double[3];
        double[] translation = new double[3];
        sourceTransform.apply(centerSource, centerGlobal);
        LinAlgHelpers.quaternionApply((double[])qViewer, (double[])centerGlobal, (double[])translation);
        LinAlgHelpers.scale((double[])translation, (double)-1.0, (double[])translation);
        LinAlgHelpers.setCol((int)3, (double[])translation, (double[][])m);
        AffineTransform3D viewerTransform = new AffineTransform3D();
        viewerTransform.set(m);
        double[] pSource = new double[]{sX1 + 0.5, sY1 + 0.5, sZ};
        double[] pGlobal = new double[3];
        double[] pScreen = new double[3];
        sourceTransform.apply(pSource, pGlobal);
        viewerTransform.apply(pGlobal, pScreen);
        double scaleX = (double)cX / pScreen[0];
        double scaleY = (double)cY / pScreen[1];
        double scale = zoomedIn ? Math.max(scaleX, scaleY) : Math.min(scaleX, scaleY);
        viewerTransform.scale(scale);
        viewerTransform.set(viewerTransform.get(0, 3) + (double)cX, 0, 3);
        viewerTransform.set(viewerTransform.get(1, 3) + (double)cY, 1, 3);
        return viewerTransform;
    }

    private static final void callLoadTimePoint(AbstractSpimSource<?> s, int timePointIndex) {
        try {
            Class<Object> clazz = null;
            boolean found = false;
            do {
                if ((clazz = clazz == null ? s.getClass() : clazz.getSuperclass()) == null) continue;
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getName().equals("loadTimepoint")) continue;
                    found = true;
                }
            } while (!found && clazz != null);
            if (!found) {
                System.out.println("Failed to find SpimSource.loadTimepoint method. Quiting.");
                return;
            }
            Method loadTimepoint = clazz.getDeclaredMethod("loadTimepoint", Integer.TYPE);
            loadTimepoint.setAccessible(true);
            loadTimepoint.invoke(s, timePointIndex);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final int getCurrentTimePointIndex(AbstractSpimSource<?> s) {
        try {
            Class<Object> clazz = null;
            Field currentTimePointIndex = null;
            do {
                if ((clazz = clazz == null ? s.getClass() : clazz.getSuperclass()) == null) continue;
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.getName().equals("currentTimePointIndex")) continue;
                    currentTimePointIndex = field;
                }
            } while (currentTimePointIndex == null && clazz != null);
            if (currentTimePointIndex == null) {
                System.out.println("Failed to find AbstractSpimSource.currentTimePointIndex. Quiting.");
                return -1;
            }
            currentTimePointIndex.setAccessible(true);
            return currentTimePointIndex.getInt(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public class MyActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (BDVPopup.this.panel == null) {
                IOFunctions.println("Panel not set for " + this.getClass().getSimpleName());
                return;
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (BDVPopup.this.bdv != null && !BDVPopup.this.bdv.getViewerFrame().isVisible()) {
                        BDVPopup.this.bdv = null;
                    }
                    if (BDVPopup.this.bdv == null) {
                        try {
                            BDVPopup.this.bdv = BDVPopup.createBDV(BDVPopup.this.panel);
                        }
                        catch (Exception e) {
                            IOFunctions.println("Could not run BigDataViewer: " + e);
                            e.printStackTrace();
                            BDVPopup.this.bdv = null;
                        }
                    } else {
                        BigDataViewerTransformationWindow.disposeViewerWindow(BDVPopup.this.bdv);
                        BDVPopup.this.bdv = null;
                    }
                }
            }).start();
        }
    }
}

