/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import ij.ImagePlus;
import ij.io.Opener;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import spim.fiji.spimdata.imgloaders.AbstractImgLoader;

public class LegacyDHMImgLoader
extends AbstractImgLoader {
    final File directory;
    final AbstractSequenceDescription<? extends BasicViewSetup, ? extends BasicViewDescription<?>, ?> sd;
    final List<String> timepoints;
    final List<String> zPlanes;
    final String stackDir;
    final String amplitudeDir;
    final String phaseDir;
    final String extension;
    final int ampChannelId;
    final int phaseChannelId;

    public LegacyDHMImgLoader(File directory, String stackDir, String amplitudeDir, String phaseDir, List<String> timepoints, List<String> zPlanes, String extension, int ampChannelId, int phaseChannelId, AbstractSequenceDescription<? extends BasicViewSetup, ? extends BasicViewDescription<?>, ?> sd) {
        this.directory = directory;
        this.stackDir = stackDir;
        this.amplitudeDir = amplitudeDir;
        this.phaseDir = phaseDir;
        this.timepoints = timepoints;
        this.zPlanes = zPlanes;
        this.extension = extension;
        this.ampChannelId = ampChannelId;
        this.phaseChannelId = phaseChannelId;
        this.sd = sd;
    }

    public String getStackDir() {
        return this.stackDir;
    }

    public String getAmplitudeDir() {
        return this.amplitudeDir;
    }

    public String getPhaseDir() {
        return this.phaseDir;
    }

    public List<String> getZPlanes() {
        return this.zPlanes;
    }

    public List<String> getTimepoints() {
        return this.timepoints;
    }

    public int getAmpChannelId() {
        return this.ampChannelId;
    }

    public int getPhaseChannelId() {
        return this.phaseChannelId;
    }

    public String getExt() {
        return this.extension;
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(ViewId view, boolean normalize) {
        String ampOrPhaseDir;
        BasicViewDescription vd = (BasicViewDescription)this.sd.getViewDescriptions().get(view);
        Dimensions d = vd.getViewSetup().getSize();
        VoxelDimensions dv = vd.getViewSetup().getVoxelSize();
        ArrayImg img = ArrayImgs.floats((long[])new long[]{d.dimension(0), d.dimension(1), d.dimension(2)});
        if (((Channel)vd.getViewSetup().getAttribute(Channel.class)).getId() == this.ampChannelId) {
            ampOrPhaseDir = this.amplitudeDir;
        } else if (((Channel)vd.getViewSetup().getAttribute(Channel.class)).getId() == this.phaseChannelId) {
            ampOrPhaseDir = this.phaseDir;
        } else {
            throw new RuntimeException("viewSetupId=" + view.getViewSetupId() + " is not Amplitude nor phase.");
        }
        LegacyDHMImgLoader.populateImage(img, this.directory, this.stackDir, ampOrPhaseDir, this.zPlanes, this.timepoints.get(view.getTimePointId()), this.extension);
        if (normalize) {
            LegacyDHMImgLoader.normalize((Img<FloatType>)img);
        }
        this.updateMetaDataCache(view, (int)d.dimension(0), (int)d.dimension(1), (int)d.dimension(2), dv.dimension(0), dv.dimension(1), dv.dimension(2));
        return img;
    }

    public RandomAccessibleInterval<UnsignedShortType> getImage(ViewId view) {
        String ampOrPhaseDir;
        BasicViewDescription vd = (BasicViewDescription)this.sd.getViewDescriptions().get(view);
        Dimensions d = vd.getViewSetup().getSize();
        VoxelDimensions dv = vd.getViewSetup().getVoxelSize();
        ArrayImg img = ArrayImgs.unsignedShorts((long[])new long[]{d.dimension(0), d.dimension(1), d.dimension(2)});
        if (((Channel)vd.getViewSetup().getAttribute(Channel.class)).getId() == this.ampChannelId) {
            ampOrPhaseDir = this.amplitudeDir;
        } else if (((Channel)vd.getViewSetup().getAttribute(Channel.class)).getId() == this.phaseChannelId) {
            ampOrPhaseDir = this.phaseDir;
        } else {
            throw new RuntimeException("viewSetupId=" + view.getViewSetupId() + " is not Amplitude nor phase.");
        }
        LegacyDHMImgLoader.populateImage(img, this.directory, this.stackDir, ampOrPhaseDir, this.zPlanes, this.timepoints.get(view.getTimePointId()), this.extension);
        this.updateMetaDataCache(view, (int)d.dimension(0), (int)d.dimension(1), (int)d.dimension(2), dv.dimension(0), dv.dimension(1), dv.dimension(2));
        return img;
    }

    @Override
    protected void loadMetaData(ViewId view) {
        BasicViewDescription vd = (BasicViewDescription)this.sd.getViewDescriptions().get(view);
        Dimensions d = vd.getViewSetup().getSize();
        VoxelDimensions dv = vd.getViewSetup().getVoxelSize();
        this.updateMetaDataCache(view, (int)d.dimension(0), (int)d.dimension(1), (int)d.dimension(2), dv.dimension(0), dv.dimension(1), dv.dimension(2));
    }

    public static final <T extends RealType<T> & NativeType<T>> void populateImage(ArrayImg<T, ?> img, File directory, String stackDir, String ampOrPhaseDirectory, List<String> zPlanes, String timepoint, String extension) {
        Opener io = new Opener();
        ArrayCursor cursor = img.cursor();
        int countDroppedFrames = 0;
        ArrayList<Integer> slices = null;
        for (int z = 0; z < zPlanes.size(); ++z) {
            File imgF = new File(new File(new File(new File(directory.getAbsolutePath(), stackDir), ampOrPhaseDirectory), zPlanes.get(z)), timepoint + extension);
            ImagePlus imp = io.openImage(imgF.getAbsolutePath());
            if (imp == null) {
                ++countDroppedFrames;
                if (slices == null) {
                    slices = new ArrayList<Integer>();
                }
                slices.add(z);
                int j = 0;
                while ((long)j < img.dimension(0) * img.dimension(1)) {
                    cursor.next();
                    ++j;
                }
                continue;
            }
            Object o = imp.getProcessor().getPixels();
            if (o instanceof byte[]) {
                for (byte b : (byte[])o) {
                    ((RealType)cursor.next()).setReal((float)UnsignedByteType.getUnsignedByte((byte)b));
                }
                continue;
            }
            if (o instanceof short[]) {
                for (short s : (short[])o) {
                    ((RealType)cursor.next()).setReal((float)UnsignedShortType.getUnsignedShort((short)s));
                }
                continue;
            }
            if (!(o instanceof float[])) continue;
            for (float s : (float[])o) {
                ((RealType)cursor.next()).setReal(s);
            }
        }
        if (countDroppedFrames > 0) {
            IOFunctions.printlnSafe("(" + new Date(System.currentTimeMillis()) + "): WARNING!!! " + countDroppedFrames + " DROPPED FRAME(s) in timepoint=" + timepoint + " channel=" + ampOrPhaseDirectory + " following slices:");
            Iterator iterator = slices.iterator();
            while (iterator.hasNext()) {
                int z = (Integer)iterator.next();
                IOFunctions.printlnSafe("(" + new Date(System.currentTimeMillis()) + "): sliceindex=" + z + ", slice=" + zPlanes.get(z));
            }
        }
    }
}

