/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.icp;

import ij.gui.GenericDialog;
import java.util.List;
import mpicbg.spim.data.sequence.ViewId;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.fiji.plugin.interestpointregistration.InterestPointRegistration;
import spim.fiji.spimdata.SpimData2;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.TransformationModel;
import spim.process.interestpointregistration.icp.IterativeClosestPointPairwise;
import spim.process.interestpointregistration.icp.IterativeClosestPointParameters;

public class IterativeClosestPoint
extends InterestPointRegistration {
    public static int defaultModel = 2;
    public static boolean defaultRegularize = true;
    protected TransformationModel model = null;
    protected IterativeClosestPointParameters parameters;

    public IterativeClosestPoint(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess) {
        super(spimData, viewIdsToProcess, channelsToProcess);
    }

    protected IterativeClosestPointPairwise pairwiseMatchingInstance(PairwiseMatch pair, String description) {
        return new IterativeClosestPointPairwise(pair, this.model, description, this.parameters);
    }

    @Override
    protected TransformationModel getTransformationModel() {
        return this.model;
    }

    @Override
    public void addQuery(GenericDialog gd, Interest_Point_Registration.RegistrationType registrationType) {
        gd.addChoice("Transformation model", TransformationModel.modelChoice, TransformationModel.modelChoice[defaultModel]);
        gd.addCheckbox("Regularize_model", defaultRegularize);
        gd.addSlider("Maximal_distance for correspondence (px)", 0.25, 40.0, IterativeClosestPointParameters.maxDistance);
        gd.addNumericField("Maximal_number of iterations", (double)IterativeClosestPointParameters.maxIterations, 0);
    }

    @Override
    public boolean parseDialog(GenericDialog gd, Interest_Point_Registration.RegistrationType registrationType) {
        defaultModel = gd.getNextChoiceIndex();
        this.model = new TransformationModel(defaultModel);
        defaultRegularize = gd.getNextBoolean();
        if (defaultRegularize && !this.model.queryRegularizedModel()) {
            return false;
        }
        double maxDistance = IterativeClosestPointParameters.maxDistance = gd.getNextNumber();
        int maxIterations = IterativeClosestPointParameters.maxIterations = (int)Math.round(gd.getNextNumber());
        this.parameters = new IterativeClosestPointParameters(maxDistance, maxIterations);
        return true;
    }

    @Override
    public IterativeClosestPoint newInstance(SpimData2 spimData, List<ViewId> viewIdsToProcess, List<ChannelProcess> channelsToProcess) {
        return new IterativeClosestPoint(spimData, viewIdsToProcess, channelsToProcess);
    }

    @Override
    public String getDescription() {
        return "Iterative closest-point (ICP, no invariance)";
    }
}

