/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.optimizationtypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mpicbg.models.AbstractModel;
import mpicbg.models.Affine3D;
import mpicbg.models.Model;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import spim.fiji.plugin.Apply_Transformation;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.ViewSetupUtils;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.GlobalOpt;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.optimizationtypes.GlobalOptimizationType;

public class GlobalOptimizationSubset {
    final ArrayList<PairwiseMatch> viewPairs;
    final String description;
    ArrayList<ViewId> viewList;

    public GlobalOptimizationSubset(ArrayList<PairwiseMatch> viewPairs, String description) {
        this.viewPairs = viewPairs;
        this.description = description;
    }

    public <M extends Model<M>> boolean computeGlobalOpt(M model, GlobalOptimizationType type, SpimData2 spimData, List<ChannelProcess> channelsToProcess, String description) {
        HashMap<ViewId, Tile<M>> tiles = GlobalOpt.compute(model, type, this, type.considerTimePointsAsUnit());
        if (tiles == null) {
            return false;
        }
        String channelList = "[";
        for (ChannelProcess c : channelsToProcess) {
            channelList = channelList + c.getLabel() + " (c=" + c.getChannel().getName() + "), ";
        }
        channelList = channelList.substring(0, channelList.length() - 2) + "]";
        AffineTransform3D mapBackModel = type.getMapBackReferenceTile(this) != null && type.getMapBackModel() != null ? this.computeMapBackModel(tiles, type, spimData) : null;
        for (ViewId viewId : this.getViews()) {
            Tile<M> tile = tiles.get(viewId);
            Affine3D tilemodel = (Affine3D)tile.getModel();
            double[][] m = new double[3][4];
            tilemodel.toMatrix(m);
            AffineTransform3D t = new AffineTransform3D();
            t.set(m[0][0], m[0][1], m[0][2], m[0][3], m[1][0], m[1][1], m[1][2], m[1][3], m[2][0], m[2][1], m[2][2], m[2][3]);
            if (mapBackModel != null) {
                t.preConcatenate(mapBackModel);
                IOFunctions.println("ViewId=" + viewId.getViewSetupId() + ": " + t);
            }
            Apply_Transformation.preConcatenateTransform(spimData, viewId, t, description + " on " + channelList);
        }
        return true;
    }

    protected <M extends Model<M>> AffineTransform3D computeMapBackModel(HashMap<ViewId, Tile<M>> tiles, GlobalOptimizationType type, SpimData2 spimData) {
        AbstractModel<?> mapBackModel = type.getMapBackModel();
        if (mapBackModel.getMinNumMatches() > 4) {
            IOFunctions.println("Cannot map back using a model that needs more than 4 points: " + mapBackModel.getClass().getSimpleName());
            return null;
        }
        IOFunctions.println("Mapping back to reference frame using a " + mapBackModel.getClass().getSimpleName());
        ViewId referenceTile = type.getMapBackReferenceTile(this);
        ViewDescription referenceTileViewDescription = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(referenceTile);
        ViewSetup referenceTileSetup = (ViewSetup)referenceTileViewDescription.getViewSetup();
        Dimensions size = ViewSetupUtils.getSizeOrLoad((BasicViewSetup)referenceTileSetup, referenceTileViewDescription.getTimePoint(), (ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader());
        long w = size.dimension(0);
        long h = size.dimension(1);
        double[][] p = new double[][]{{0.0, 0.0, 0.0}, {w, 0.0, 0.0}, {0.0, h, 0.0}, {w, h, 0.0}};
        double[][] pa = new double[4][3];
        ViewRegistration inputModel = spimData.getViewRegistrations().getViewRegistration(referenceTile);
        for (int i = 0; i < p.length; ++i) {
            inputModel.getModel().apply(p[i], pa[i]);
        }
        Model outputModel = tiles.get(referenceTile).getModel();
        double[][] pb = new double[4][3];
        for (int i = 0; i < p.length; ++i) {
            pb[i] = outputModel.apply(pa[i]);
        }
        try {
            ArrayList<PointMatch> pm = new ArrayList<PointMatch>();
            for (int i = 0; i < p.length; ++i) {
                pm.add(new PointMatch(new Point(pb[i]), new Point(pa[i])));
            }
            mapBackModel.fit(pm);
        }
        catch (Exception e) {
            IOFunctions.println("Could not compute model for mapping back: " + e);
            e.printStackTrace();
            return null;
        }
        AffineTransform3D mapBack = new AffineTransform3D();
        double[][] m = new double[3][4];
        ((Affine3D)mapBackModel).toMatrix(m);
        mapBack.set(m[0][0], m[0][1], m[0][2], m[0][3], m[1][0], m[1][1], m[1][2], m[1][3], m[2][0], m[2][1], m[2][2], m[2][3]);
        IOFunctions.println("Model for mapping back: " + mapBack + "\n");
        return mapBack;
    }

    public List<ViewId> getViews() {
        if (this.viewList != null) {
            return this.viewList;
        }
        HashSet<ViewId> viewSet = new HashSet<ViewId>();
        for (PairwiseMatch pair : this.getViewPairs()) {
            viewSet.add(pair.getViewIdA());
            viewSet.add(pair.getViewIdB());
        }
        this.viewList = new ArrayList();
        this.viewList.addAll(viewSet);
        Collections.sort(this.viewList);
        return this.viewList;
    }

    public List<PairwiseMatch> getViewPairs() {
        return this.viewPairs;
    }

    public String getDescription() {
        return this.description;
    }
}

