/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.cache;

import bdv.cache.CacheControl;
import bdv.cache.SharedQueue;
import bdv.img.cache.CacheArrayLoader;
import bdv.img.cache.CreateInvalidVolatileCell;
import bdv.img.cache.EmptyArrayCreator;
import bdv.img.cache.SimpleCacheArrayLoader;
import bdv.img.cache.VolatileCachedCellImg;
import java.util.concurrent.Callable;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.queue.BlockingFetchQueues;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.cache.ref.WeakRefVolatileCache;
import net.imglib2.cache.util.KeyBimap;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;

public class VolatileGlobalCellCache
implements CacheControl {
    private final BlockingFetchQueues<Callable<?>> queue;
    protected final LoaderCache<Key, Cell<?>> backingCache;

    public VolatileGlobalCellCache(int maxNumLevels, int numFetcherThreads) {
        this.queue = new SharedQueue(numFetcherThreads, maxNumLevels);
        this.backingCache = new SoftRefLoaderCache();
    }

    public VolatileGlobalCellCache(BlockingFetchQueues<Callable<?>> queue) {
        this.queue = queue;
        this.backingCache = new SoftRefLoaderCache();
    }

    @Override
    public void prepareNextFrame() {
        this.queue.clearToPrefetch();
    }

    public void clearCache() {
        this.backingCache.invalidateAll();
    }

    public <T extends NativeType<T>, A extends DataAccess> VolatileCachedCellImg<T, A> createImg(CellGrid grid, int timepoint, int setup, int level, CacheHints cacheHints, CacheArrayLoader<A> cacheArrayLoader, T type) {
        CacheLoader loader = key -> {
            int n = grid.numDimensions();
            long[] cellMin = new long[n];
            int[] cellDims = new int[n];
            grid.getCellDimensions((long)key, cellMin, cellDims);
            return new Cell(cellDims, cellMin, cacheArrayLoader.loadArray(timepoint, setup, level, cellDims, cellMin));
        };
        return this.createImg(grid, timepoint, setup, level, cacheHints, loader, cacheArrayLoader.getEmptyArrayCreator(), type);
    }

    public <T extends NativeType<T>, A extends DataAccess> VolatileCachedCellImg<T, A> createImg(CellGrid grid, int timepoint, int setup, int level, CacheHints cacheHints, SimpleCacheArrayLoader<A> cacheArrayLoader, T type) {
        CacheLoader loader = key -> {
            int n = grid.numDimensions();
            long[] cellMin = new long[n];
            int[] cellDims = new int[n];
            long[] cellGridPosition = new long[n];
            grid.getCellDimensions((long)key, cellMin, cellDims);
            grid.getCellGridPositionFlat((long)key, cellGridPosition);
            return new Cell(cellDims, cellMin, cacheArrayLoader.loadArray(cellGridPosition, cellDims));
        };
        return this.createImg(grid, timepoint, setup, level, cacheHints, loader, cacheArrayLoader.getEmptyArrayCreator(), type);
    }

    private <T extends NativeType<T>, A extends DataAccess> VolatileCachedCellImg<T, A> createImg(CellGrid grid, int timepoint, int setup, int level, CacheHints cacheHints, CacheLoader<Long, Cell<?>> loader, EmptyArrayCreator<A> emptyArrayCreator, T type) {
        KeyBimap bimap = KeyBimap.build(index -> new Key(timepoint, setup, level, (long)index), key -> ((Key)key).timepoint == timepoint && ((Key)key).setup == setup && ((Key)key).level == level ? Long.valueOf(((Key)key).index) : null);
        Cache cache = this.backingCache.mapKeys(bimap).withLoader(loader);
        CreateInvalidVolatileCell createInvalid = emptyArrayCreator == null ? CreateInvalidVolatileCell.get(grid, type, false) : new CreateInvalidVolatileCell(grid, type.getEntitiesPerPixel(), emptyArrayCreator);
        WeakRefVolatileCache vcache = new WeakRefVolatileCache(cache, this.queue, createInvalid);
        VolatileCachedCellImg img = new VolatileCachedCellImg(grid, type, cacheHints, vcache);
        return img;
    }

    public static class Key {
        private final int timepoint;
        private final int setup;
        private final int level;
        private final long index;
        final int hashcode;

        public Key(int timepoint, int setup, int level, long index) {
            this.timepoint = timepoint;
            this.setup = setup;
            this.level = level;
            this.index = index;
            int value = Long.hashCode(index);
            value = 31 * value + level;
            value = 31 * value + setup;
            this.hashcode = value = 31 * value + timepoint;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key that = (Key)other;
            return this.index == that.index && this.timepoint == that.timepoint && this.setup == that.setup && this.level == that.level;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }
}

