/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.splitpanel;

import bdv.ui.UIUtils;
import bdv.viewer.animate.OverlayAnimator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.util.function.BooleanSupplier;
import javax.swing.ImageIcon;

class SplitPaneOneTouchExpandAnimator
implements OverlayAnimator {
    private final BooleanSupplier isCollapsed;
    private ImageIcon rightArrowIcon;
    private ImageIcon leftArrowIcon;
    private int imgw;
    private int imgh;
    private int borderWidth;
    private int triggerHeight;
    private final double animationSpeed = 0.09;
    private final float backgroundAlpha = 0.65f;
    private float alpha = 1.0f;
    private int viewPortWidth;
    private int viewPortHeight;
    private double uiScale = -1.0;
    private AnimationType requestedAnimationType = AnimationType.NONE;
    private long last_time;
    private PaintState paintState;
    private Animator animator;

    public SplitPaneOneTouchExpandAnimator(BooleanSupplier isCollapsed) {
        this.isCollapsed = isCollapsed;
    }

    public synchronized void startAnimation(AnimationType animationType) {
        this.requestedAnimationType = animationType;
    }

    private void updateUIScale() {
        double s = UIUtils.getUIScaleFactor(this);
        if (s != this.uiScale) {
            this.uiScale = s;
            this.rightArrowIcon = new ImageIcon(SplitPaneOneTouchExpandAnimator.class.getResource("rightdoublearrow_tiny.png"));
            this.leftArrowIcon = new ImageIcon(SplitPaneOneTouchExpandAnimator.class.getResource("leftdoublearrow_tiny.png"));
            this.imgw = this.leftArrowIcon.getIconWidth();
            this.imgh = this.leftArrowIcon.getIconHeight();
            if (this.uiScale != 1.0) {
                this.rightArrowIcon.setImage(this.rightArrowIcon.getImage().getScaledInstance((int)(this.uiScale * (double)this.imgw), (int)(this.uiScale * (double)this.imgh), 4));
                this.leftArrowIcon.setImage(this.leftArrowIcon.getImage().getScaledInstance((int)(this.uiScale * (double)this.imgw), (int)(this.uiScale * (double)this.imgh), 4));
                this.imgw = this.leftArrowIcon.getIconWidth();
                this.imgh = this.leftArrowIcon.getIconHeight();
            }
            this.borderWidth = (int)((double)this.imgw + 10.0 * this.uiScale);
            this.triggerHeight = (int)((double)this.imgh + 10.0 * this.uiScale);
        }
    }

    @Override
    public void paint(Graphics2D g, long time) {
        this.updateUIScale();
        this.viewPortWidth = g.getClipBounds().width;
        this.viewPortHeight = g.getClipBounds().height;
        if (this.requestedAnimationType != AnimationType.NONE) {
            if (this.animator == null || this.animator.animationType() != this.requestedAnimationType) {
                this.last_time = time;
                switch (this.requestedAnimationType) {
                    case SHOW_EXPAND: {
                        this.animator = new ShowExpandButton(this.animator);
                        break;
                    }
                    case HIDE_EXPAND: {
                        this.animator = new HideExpandButton(this.animator);
                        break;
                    }
                    case SHOW_COLLAPSE: {
                        this.animator = new ShowCollapseButton();
                        break;
                    }
                    case HIDE_COLLAPSE: {
                        this.animator = new HideCollapseButton();
                    }
                }
            }
            this.requestedAnimationType = AnimationType.NONE;
        }
        if (this.animator != null) {
            long delta_time = time - this.last_time;
            this.last_time = time;
            this.paintState = this.animator.animate(delta_time);
            if (this.animator.isComplete()) {
                this.animator = null;
            }
        }
        if (this.paintState != null) {
            this.paint(g, this.paintState);
        }
    }

    void clearPaintState() {
        this.paintState = null;
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    @Override
    public boolean requiresRepaint() {
        return this.animator != null;
    }

    public boolean isInBorderRegion(int x, int y) {
        return x > this.viewPortWidth - this.borderWidth;
    }

    public boolean isInTriggerRegion(int x, int y) {
        return x > this.viewPortWidth - this.borderWidth && Math.abs(this.viewPortHeight - 2 * y) < this.triggerHeight;
    }

    private void paint(Graphics2D g, PaintState state) {
        int imgX = this.viewPortWidth - (int)((double)this.imgw * state.imgRatio + 10.0 * state.bumpRatio);
        int bgX = this.viewPortWidth - (int)((double)this.imgw * state.bgRatio + 10.0 * state.bumpRatio);
        int y = (this.viewPortHeight - this.imgh) / 2;
        this.drawBackground(g, bgX, y, state.alpha);
        this.drawImg(g, this.isCollapsed.getAsBoolean() ? this.leftArrowIcon : this.rightArrowIcon, imgX, y, state.alpha);
    }

    private void drawBackground(Graphics2D g, int x, int y, float alpha) {
        int width = this.imgw + 60;
        int height = this.imgh;
        g.setColor(new Color(0.28f, 0.5f, 0.96f, Math.min(alpha, 0.65f)));
        g.fillRoundRect(x, y, width, height, 25, 25);
    }

    private void drawImg(Graphics2D g, ImageIcon img, int x, int y, float alpha) {
        Composite oldComposite = g.getComposite();
        AlphaComposite alcom = AlphaComposite.getInstance(3, alpha);
        g.setComposite(alcom);
        g.drawImage(img.getImage(), x, y, null);
        g.setComposite(oldComposite);
    }

    private static double cos(double t) {
        return 0.5 - 0.5 * Math.cos(Math.PI * t);
    }

    private void updateAlpha(boolean fadeIn, long delta_time) {
        if (fadeIn) {
            this.alpha = (float)((double)this.alpha + 0.004 * (double)delta_time);
            this.alpha = Math.min(1.0f, this.alpha);
        } else {
            this.alpha = (float)((double)this.alpha - 0.004 * (double)delta_time);
            this.alpha = Math.max(0.25f, this.alpha);
        }
    }

    private class ShowExpandButton
    implements Animator {
        private final double expandAnimationSpeed;
        private int keyFrame;
        private double expandRatio;
        private boolean complete;

        public ShowExpandButton(Animator currentAnimator) {
            this.expandAnimationSpeed = 0.09 / (double)SplitPaneOneTouchExpandAnimator.this.imgw;
            this.complete = false;
            this.expandRatio = currentAnimator != null && !currentAnimator.isComplete() && currentAnimator instanceof HideExpandButton ? ((HideExpandButton)currentAnimator).expandRatio : 0.0;
            this.keyFrame = this.expandRatio > 0.0 ? 1 : 0;
        }

        @Override
        public PaintState animate(long delta_time) {
            if (this.keyFrame == 0) {
                this.expandRatio += (double)(delta_time * 2L) * this.expandAnimationSpeed;
                this.expandRatio = Math.min(1.0, Math.max(0.0, this.expandRatio));
                if (this.expandRatio == 1.0) {
                    this.keyFrame = 1;
                }
            } else if (this.keyFrame == 1) {
                this.expandRatio -= (double)delta_time * this.expandAnimationSpeed;
                this.expandRatio = Math.min(1.0, Math.max(0.0, this.expandRatio));
                if (this.expandRatio <= 0.5) {
                    this.keyFrame = 2;
                }
            } else if (this.keyFrame == 2) {
                this.expandRatio += (double)delta_time * this.expandAnimationSpeed;
                this.expandRatio = Math.min(1.0, Math.max(0.0, this.expandRatio));
                if (this.expandRatio == 1.0) {
                    this.keyFrame = 3;
                }
            } else {
                this.expandRatio = 1.0;
            }
            SplitPaneOneTouchExpandAnimator.this.updateAlpha(true, delta_time);
            this.complete = this.keyFrame >= 3;
            double imgRatio = SplitPaneOneTouchExpandAnimator.cos(this.expandRatio);
            double bgRatio = this.keyFrame > 0 ? 1.0 : imgRatio;
            return new PaintState(imgRatio, bgRatio, 0.0, SplitPaneOneTouchExpandAnimator.this.alpha);
        }

        @Override
        public AnimationType animationType() {
            return AnimationType.SHOW_EXPAND;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }
    }

    private class HideExpandButton
    implements Animator {
        private final double expandAnimationSpeed;
        private double expandRatio;
        private boolean complete;

        public HideExpandButton(Animator currentAnimator) {
            this.expandAnimationSpeed = 0.09 / (double)SplitPaneOneTouchExpandAnimator.this.imgw;
            this.complete = false;
            this.expandRatio = currentAnimator != null && !currentAnimator.isComplete() && currentAnimator instanceof ShowExpandButton ? ((ShowExpandButton)currentAnimator).expandRatio : 1.0;
        }

        @Override
        public PaintState animate(long delta_time) {
            this.expandRatio -= 2.0 * this.expandAnimationSpeed * (double)delta_time;
            this.expandRatio = Math.min(1.0, Math.max(0.0, this.expandRatio));
            SplitPaneOneTouchExpandAnimator.this.updateAlpha(false, delta_time);
            this.complete = this.expandRatio <= 0.0;
            double imgRatio = SplitPaneOneTouchExpandAnimator.cos(this.expandRatio);
            return new PaintState(imgRatio, imgRatio, 0.0, SplitPaneOneTouchExpandAnimator.this.alpha);
        }

        @Override
        public AnimationType animationType() {
            return AnimationType.HIDE_EXPAND;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }
    }

    private class ShowCollapseButton
    implements Animator {
        private final double bumpAnimationSpeed = 0.009;
        private int keyFrame = 0;
        private double bumpRatio = 0.0;
        private boolean complete = false;

        private ShowCollapseButton() {
        }

        @Override
        public PaintState animate(long delta_time) {
            if (this.keyFrame == 0) {
                this.bumpRatio += 0.009 * (double)delta_time;
                this.bumpRatio = Math.min(1.0, Math.max(0.0, this.bumpRatio));
                if (this.bumpRatio == 1.0) {
                    this.keyFrame = 1;
                }
            } else if (this.keyFrame == 1) {
                this.bumpRatio -= 0.009 * (double)delta_time;
                this.bumpRatio = Math.min(1.0, Math.max(0.0, this.bumpRatio));
                if (this.bumpRatio == 0.0) {
                    this.keyFrame = 2;
                }
            }
            SplitPaneOneTouchExpandAnimator.this.updateAlpha(true, delta_time);
            this.complete = this.keyFrame >= 2;
            return new PaintState(1.0, 1.0, SplitPaneOneTouchExpandAnimator.cos(this.bumpRatio), SplitPaneOneTouchExpandAnimator.this.alpha);
        }

        @Override
        public AnimationType animationType() {
            return AnimationType.SHOW_COLLAPSE;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }
    }

    private class HideCollapseButton
    implements Animator {
        private boolean complete = false;

        private HideCollapseButton() {
        }

        @Override
        public PaintState animate(long delta_time) {
            SplitPaneOneTouchExpandAnimator.this.updateAlpha(false, delta_time);
            this.complete = (double)SplitPaneOneTouchExpandAnimator.this.alpha <= 0.25;
            return new PaintState(1.0, 1.0, 0.0, SplitPaneOneTouchExpandAnimator.this.alpha);
        }

        @Override
        public AnimationType animationType() {
            return AnimationType.HIDE_COLLAPSE;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }
    }

    private static interface Animator {
        public PaintState animate(long var1);

        public AnimationType animationType();

        public boolean isComplete();
    }

    private static class PaintState {
        final double imgRatio;
        final double bgRatio;
        final double bumpRatio;
        final float alpha;

        private PaintState(double imgRatio, double bgRatio, double bumpRatio, float alpha) {
            this.imgRatio = imgRatio;
            this.bgRatio = bgRatio;
            this.bumpRatio = bumpRatio;
            this.alpha = alpha;
        }
    }

    public static enum AnimationType {
        SHOW_EXPAND,
        HIDE_EXPAND,
        SHOW_COLLAPSE,
        HIDE_COLLAPSE,
        NONE;

    }
}

