/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush.neighborhood;

import java.util.Arrays;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.logic.BitType;
import sc.fiji.labkit.ui.utils.sparse.SparseIterableRegion;

public class Ellipsoid {
    private final double[] center;
    private final double[] axes;

    public static IterableRegion<BitType> asIterableRegion(double[] center, double[] axes) {
        return new Ellipsoid(center, axes).asIterableRegion();
    }

    Ellipsoid(double[] center, double[] axes) {
        if (center.length != axes.length) {
            throw new IllegalArgumentException("Ellipsoid center and size must have the same number of dimensions: center: " + Arrays.toString(center) + " sizes: " + Arrays.toString(axes));
        }
        this.center = center;
        this.axes = axes;
    }

    IterableRegion<BitType> asIterableRegion() {
        SparseIterableRegion sparseIterableRegion = new SparseIterableRegion(this.boundingBox());
        RandomAccess<BitType> ra = sparseIterableRegion.randomAccess();
        this.addPoints(this.boundingBox().numDimensions() - 1, ra, 1.0);
        return sparseIterableRegion;
    }

    private void addPoints(int d, RandomAccess<BitType> randomAccess, double squaredScaleFactor) {
        double c = this.center[d];
        double scaleFactor = Math.sqrt(squaredScaleFactor);
        long min = Ellipsoid.roundDown(c - this.axes[d] * scaleFactor);
        long center_min = Ellipsoid.roundDown(c);
        long center_max = Ellipsoid.roundUp(c);
        long max = Ellipsoid.roundUp(c + this.axes[d] * scaleFactor);
        if (d == 0) {
            randomAccess.setPosition(min, 0);
            for (long x = min; x <= max; ++x) {
                ((BitType)randomAccess.get()).set(true);
                randomAccess.fwd(0);
            }
        } else {
            long x;
            for (x = min; x < center_min; ++x) {
                randomAccess.setPosition(x, d);
                this.addPoints(d - 1, randomAccess, squaredScaleFactor - this.sqr((c - (double)x - 0.5) / this.axes[d]));
            }
            for (x = center_min; x <= center_max; ++x) {
                randomAccess.setPosition(x, d);
                this.addPoints(d - 1, randomAccess, squaredScaleFactor);
            }
            for (x = center_max + 1L; x <= max; ++x) {
                randomAccess.setPosition(x, d);
                this.addPoints(d - 1, randomAccess, squaredScaleFactor - this.sqr(((double)x - c - 0.5) / this.axes[d]));
            }
        }
    }

    private double sqr(double v) {
        return v * v;
    }

    Interval boundingBox() {
        int n = this.center.length;
        long[] min = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Ellipsoid.roundDown(this.center[d] - this.axes[d]);
        }
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            max[d] = Ellipsoid.roundUp(this.center[d] + this.axes[d]);
        }
        return new FinalInterval(min, max);
    }

    static long roundUp(double v) {
        return Math.round(v);
    }

    static long roundDown(double v) {
        return -Math.round(-v);
    }
}

