/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.BoundingLeaf;
import org.scijava.java3d.BoundingLeafRetained;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.IllegalSceneGraphException;
import org.scijava.java3d.IllegalSharingException;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LeafRetained;
import org.scijava.java3d.MediaContainer;
import org.scijava.java3d.MediaContainerRetained;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.SoundSchedulerAtom;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.View;
import org.scijava.java3d.VirtualUniverse;

abstract class SoundRetained
extends LeafRetained {
    static final int NULL_SOUND = -1;
    MediaContainer soundData = null;
    float initialGain = 1.0f;
    int loopCount = 0;
    boolean enable = false;
    boolean release = false;
    boolean continuous = false;
    boolean mute = false;
    boolean pause = false;
    float priority = 1.0f;
    float rate = 1.0f;
    Bounds schedulingRegion = null;
    BoundingLeafRetained boundingLeaf = null;
    Bounds transformedRegion = null;
    static final int SOUND_DATA_DIRTY_BIT = 1;
    static final int INITIAL_GAIN_DIRTY_BIT = 2;
    static final int LOOP_COUNT_DIRTY_BIT = 4;
    static final int BOUNDS_DIRTY_BIT = 8;
    static final int BOUNDING_LEAF_DIRTY_BIT = 16;
    static final int PRIORITY_DIRTY_BIT = 32;
    static final int POSITION_DIRTY_BIT = 64;
    static final int DISTANCE_GAIN_DIRTY_BIT = 128;
    static final int BACK_DISTANCE_GAIN_DIRTY_BIT = 256;
    static final int DIRECTION_DIRTY_BIT = 512;
    static final int ANGULAR_ATTENUATION_DIRTY_BIT = 1024;
    static final int RATE_DIRTY_BIT = 2048;
    static final int BOUNDS_CHANGED = 24;
    static final int ATTRIBUTE_DIRTY_BITS = 2087;
    static final int POSITIONAL_DIRTY_BITS = 2279;
    static final int DIRECTIONAL_DIRTY_BITS = 4071;
    static final int ALL_ATTIBS_DIRTY_BITS = 4095;
    static final int LIVE_DIRTY_BIT = 1;
    static final int IMMEDIATE_MODE_DIRTY_BIT = 2;
    static final int LOAD_SOUND_DIRTY_BIT = 4;
    static final int RELEASE_DIRTY_BIT = 8;
    static final int CONTINUOUS_DIRTY_BIT = 16;
    static final int ENABLE_DIRTY_BIT = 32;
    static final int MUTE_DIRTY_BIT = 64;
    static final int PAUSE_DIRTY_BIT = 128;
    static final int XFORM_DIRTY_BIT = 32768;
    static final int ALL_STATE_DIRTY_BITS = 33023;
    int soundType = -1;
    SoundRetained sgSound = null;
    HashKey key = null;
    SoundRetained[] mirrorSounds = new SoundRetained[1];
    int numMirrorSounds = 0;
    private SoundSchedulerAtom[] loadedAtoms = new SoundSchedulerAtom[1];
    private int atomCount = 0;
    boolean inImmCtx = false;
    static final int LOAD_COMPLETE = 2;
    static final int LOAD_PENDING = 1;
    static final int LOAD_NULL = 0;
    static final int LOAD_FAILED = -1;
    int loadStatus = 0;
    long duration = -1L;
    static final int targetThreads = 514;
    boolean isViewScoped = false;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundRetained() {
    }

    void dispatchAttribChange(int dirtyBit, Object argument) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 514;
        createMessage.type = 38;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(dirtyBit);
        createMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorSounds) : new Integer(1);
        createMessage.args[3] = this.mirrorSounds.clone();
        createMessage.args[4] = argument;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    void dispatchStateChange(int dirtyBit, Object argument) {
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 514;
        createMessage.type = 45;
        createMessage.universe = this.universe;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(dirtyBit);
        createMessage.args[2] = this.inSharedGroup ? new Integer(this.numMirrorSounds) : new Integer(1);
        createMessage.args[3] = this.mirrorSounds.clone();
        createMessage.args[4] = argument;
        VirtualUniverse.mc.processMessage(createMessage);
    }

    void setSoundDataState(MediaContainer soundData) {
        this.soundData = soundData;
    }

    void setSoundData(MediaContainer soundData) {
        if (this.soundData == soundData) {
            return;
        }
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).removeUser(this);
        }
        if (this.source != null && this.source.isLive()) {
            if (this.soundData != null) {
                ((MediaContainerRetained)this.soundData.retained).clearLive(this.refCount);
            }
            if (soundData != null) {
                ((MediaContainerRetained)soundData.retained).setLive(this.inBackgroundGroup, this.refCount);
                ((MediaContainerRetained)soundData.retained).addUser(this);
            }
        }
        this.soundData = soundData;
        this.dispatchAttribChange(1, soundData);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    MediaContainer getSoundData() {
        return this.soundData;
    }

    void setInitialGain(float scaleFactor) {
        this.initialGain = scaleFactor < 0.0f ? 0.0f : scaleFactor;
        this.dispatchAttribChange(2, new Float(scaleFactor));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    float getInitialGain() {
        return this.initialGain;
    }

    void setLoop(int loopCount) {
        this.loopCount = loopCount < -1 ? -1 : loopCount;
        this.dispatchAttribChange(4, new Integer(loopCount));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    int getLoop() {
        return this.loopCount;
    }

    void setReleaseEnable(boolean state) {
        this.release = state;
        this.dispatchAttribChange(8, state ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getReleaseEnable() {
        return this.release;
    }

    void setContinuousEnable(boolean state) {
        this.continuous = state;
        this.dispatchAttribChange(16, state ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getContinuousEnable() {
        return this.continuous;
    }

    void setEnable(boolean state) {
        this.enable = state;
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
        this.dispatchStateChange(32, new Boolean(this.enable));
    }

    boolean getEnable() {
        return this.enable;
    }

    void setSchedulingBounds(Bounds region) {
        if (region != null) {
            this.schedulingRegion = (Bounds)region.clone();
            if (this.staticTransform != null) {
                this.schedulingRegion.transform(this.staticTransform.transform);
            }
            this.transformedRegion = (Bounds)this.schedulingRegion.clone();
        } else {
            this.schedulingRegion = null;
            this.transformedRegion = null;
        }
        this.dispatchAttribChange(8, region);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    Bounds getSchedulingBounds() {
        Bounds b = null;
        if (this.schedulingRegion != null) {
            b = (Bounds)this.schedulingRegion.clone();
            if (this.staticTransform != null) {
                Transform3D invTransform = this.staticTransform.getInvTransform();
                b.transform(invTransform);
            }
        }
        return b;
    }

    void setSchedulingBoundingLeaf(BoundingLeaf region) {
        int i;
        int numSnds = this.numMirrorSounds;
        if (this.numMirrorSounds == 0) {
            numSnds = 1;
        }
        if (this.boundingLeaf != null && this.source != null && this.source.isLive()) {
            for (i = 0; i < numSnds; ++i) {
                this.boundingLeaf.mirrorBoundingLeaf.removeUser(this.mirrorSounds[i]);
            }
        }
        if (region != null) {
            this.boundingLeaf = (BoundingLeafRetained)region.retained;
            if (this.source != null && this.source.isLive()) {
                for (i = 0; i < numSnds; ++i) {
                    this.boundingLeaf.mirrorBoundingLeaf.addUser(this.mirrorSounds[i]);
                }
            }
        } else {
            this.boundingLeaf = null;
        }
        this.dispatchAttribChange(16, region);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    BoundingLeaf getSchedulingBoundingLeaf() {
        if (this.boundingLeaf != null) {
            return (BoundingLeaf)this.boundingLeaf.source;
        }
        return null;
    }

    @Override
    synchronized void updateMirrorObject(Object[] objs) {
        Object trans = null;
        int component = (Integer)objs[1];
        if (component == -1) {
            this.initMirrorObject((SoundRetained)objs[2]);
        }
        super.updateMirrorObject(objs);
    }

    void updateBoundingLeaf(long refTime) {
        if (this.boundingLeaf != null && this.boundingLeaf.switchState.currentSwitchOn) {
            this.transformedRegion = this.boundingLeaf.transformedRegion;
        } else if (this.schedulingRegion != null) {
            this.transformedRegion = this.schedulingRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.schedulingRegion, this.getLastLocalToVworld());
        } else {
            this.transformedRegion = null;
        }
    }

    void setPriority(float rank) {
        if (rank == this.priority) {
            return;
        }
        this.priority = rank;
        this.dispatchAttribChange(32, new Float(rank));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    float getPriority() {
        return this.priority;
    }

    long getDuration() {
        return this.duration;
    }

    void setRateScaleFactor(float scaleFactor) {
        this.rate = scaleFactor;
        this.dispatchAttribChange(2048, new Float(scaleFactor));
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    float getRateScaleFactor() {
        return this.rate;
    }

    void changeAtomList(SoundSchedulerAtom atom, int loadStatus) {
        if (atom == null) {
            return;
        }
        if (loadStatus == 2) {
            for (int i = 0; i < this.atomCount; ++i) {
                if (atom != this.loadedAtoms[i]) continue;
                return;
            }
            ++this.atomCount;
            int currentArrayLength = this.loadedAtoms.length;
            if (this.atomCount > currentArrayLength) {
                this.loadedAtoms = new SoundSchedulerAtom[2 * currentArrayLength];
            }
            this.loadedAtoms[this.atomCount - 1] = atom;
            this.duration = atom.sampleLength;
        } else {
            if (this.atomCount == 0) {
                return;
            }
            boolean atomFound = false;
            for (int i = 0; i < this.atomCount; ++i) {
                if (atom != this.loadedAtoms[i]) continue;
                atomFound = true;
            }
            if (!atomFound) {
                return;
            }
            for (int j = i; j < this.atomCount; ++j) {
                this.loadedAtoms[j] = this.loadedAtoms[j + 1];
            }
            --this.atomCount;
            if (this.atomCount == 0) {
                this.duration = -1L;
            }
        }
    }

    boolean isReady() {
        boolean atomFoundReady = true;
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null) continue;
            if (atom.loadStatus == 2) {
                atomFoundReady = true;
                continue;
            }
            return false;
        }
        return atomFoundReady;
    }

    boolean isReady(View viewRef) {
        if (viewRef == null) {
            return false;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null || atom.soundScheduler.view != viewRef) continue;
            return atom.loadStatus == 2;
        }
        return false;
    }

    boolean isPlaying() {
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null || atom.status != 1) continue;
            return true;
        }
        return false;
    }

    boolean isPlaying(View viewRef) {
        if (viewRef == null) {
            return false;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null || atom.soundScheduler.view != viewRef) continue;
            return atom.status == 1;
        }
        return false;
    }

    boolean isPlayingSilently() {
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null) continue;
            return atom.status == 2;
        }
        return false;
    }

    boolean isPlayingSilently(View viewRef) {
        if (viewRef == null) {
            return false;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null || atom.soundScheduler.view != viewRef) continue;
            return atom.status == 2;
        }
        return false;
    }

    int getNumberOfChannelsUsed() {
        View primaryView = this.universe.getCurrentView();
        if (primaryView == null) {
            return 0;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null || atom.soundScheduler.view != primaryView) continue;
            return atom.numberChannels;
        }
        return 0;
    }

    int getNumberOfChannelsUsed(View viewRef) {
        if (viewRef == null) {
            return 0;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            SoundSchedulerAtom atom = this.loadedAtoms[i];
            if (atom == null || atom.soundScheduler == null || atom.soundScheduler.view != viewRef) continue;
            return atom.numberChannels;
        }
        return 0;
    }

    void setMute(boolean state) {
        this.mute = state;
        this.dispatchAttribChange(64, state ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getMute() {
        return this.mute;
    }

    void setPause(boolean state) {
        this.pause = state;
        this.dispatchAttribChange(128, state ? Boolean.TRUE : Boolean.FALSE);
        if (this.source != null && this.source.isLive()) {
            this.notifySceneGraphChanged(false);
        }
    }

    boolean getPause() {
        return this.pause;
    }

    void setInImmCtx(boolean inCtx) {
        this.inImmCtx = inCtx;
    }

    boolean getInImmCtx() {
        return this.inImmCtx;
    }

    SoundRetained getMirrorSound(HashKey key) {
        if (this.inSharedGroup) {
            int i;
            for (i = 0; i < this.numMirrorSounds; ++i) {
                if (!this.mirrorSounds[i].key.equals((Object)key)) continue;
                return this.mirrorSounds[i];
            }
            if (this.numMirrorSounds == this.mirrorSounds.length) {
                SoundRetained[] newSounds = new SoundRetained[this.numMirrorSounds * 2];
                for (i = 0; i < this.numMirrorSounds; ++i) {
                    newSounds[i] = this.mirrorSounds[i];
                }
                this.mirrorSounds = newSounds;
            }
            this.mirrorSounds[this.numMirrorSounds] = (SoundRetained)this.clone();
            this.mirrorSounds[this.numMirrorSounds].key = key;
            this.mirrorSounds[this.numMirrorSounds].sgSound = this;
            return this.mirrorSounds[this.numMirrorSounds++];
        }
        if (this.mirrorSounds[0] == null) {
            this.mirrorSounds[0] = (SoundRetained)this.clone();
            this.mirrorSounds[0].sgSound = this;
        }
        return this.mirrorSounds[0];
    }

    synchronized void initMirrorObject(SoundRetained ms) {
        Object region = null;
        ms.setSchedulingBounds(this.getSchedulingBounds());
        ms.setSchedulingBoundingLeaf(this.getSchedulingBoundingLeaf());
        ms.sgSound = this.sgSound;
        ms.inImmCtx = this.inImmCtx;
        ms.setSoundData(this.getSoundData());
        ms.parent = this.parent;
        ms.inSharedGroup = false;
        ms.locale = this.locale;
        ms.parent = this.parent;
        ms.localBounds = (Bounds)this.localBounds.clone();
        ms.transformedRegion = null;
        if (this.boundingLeaf != null) {
            if (ms.boundingLeaf != null) {
                ms.boundingLeaf.removeUser(ms);
            }
            ms.boundingLeaf = this.boundingLeaf.mirrorBoundingLeaf;
            ms.boundingLeaf.addUser(ms);
            ms.transformedRegion = ms.boundingLeaf.transformedRegion;
        } else {
            ms.boundingLeaf = null;
        }
        if (this.schedulingRegion != null) {
            ms.schedulingRegion = (Bounds)this.schedulingRegion.clone();
            if (ms.transformedRegion == null) {
                ms.transformedRegion = (Bounds)ms.schedulingRegion.clone();
                ms.transformedRegion.transform(ms.schedulingRegion, ms.getLastLocalToVworld());
            }
        } else {
            ms.schedulingRegion = null;
        }
    }

    @Override
    void setLive(SetLiveState s) {
        if (this.inImmCtx) {
            throw new IllegalSharingException(J3dI18N.getString("SoundRetained2"));
        }
        super.setLive(s);
        if (this.inBackgroundGroup) {
            throw new IllegalSceneGraphException(J3dI18N.getString("SoundRetained3"));
        }
        if (this.loadStatus == 1) {
            this.dispatchStateChange(4, this.soundData);
        }
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).setLive(this.inBackgroundGroup, s.refCount);
        }
        if (s.inSharedGroup) {
            for (int i = 0; i < s.keys.length; ++i) {
                SoundRetained ms = this.getMirrorSound(s.keys[i]);
                ms.localToVworld = new Transform3D[1][];
                ms.localToVworldIndex = new int[1][];
                int j = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (j < 0) {
                    System.err.println("SoundRetained : Can't find hashKey");
                }
                ms.localToVworld[0] = this.localToVworld[j];
                ms.localToVworldIndex[0] = this.localToVworldIndex[j];
                if (s.viewScopedNodeList != null && s.viewLists != null) {
                    s.viewScopedNodeList.add(ms);
                    s.scopedNodesViewList.add(s.viewLists.get(i));
                } else {
                    s.nodeList.add(ms);
                }
                if (s.switchTargets != null && s.switchTargets[i] != null) {
                    s.switchTargets[i].addNode(ms, 3);
                }
                ms.switchState = s.switchStates.get(j);
                if (s.transformTargets == null || s.transformTargets[i] == null) continue;
                s.transformTargets[i].addNode(ms, 3);
                s.notifyThreads |= 0x2000;
            }
        } else {
            SoundRetained ms = this.getMirrorSound(null);
            ms.localToVworld = new Transform3D[1][];
            ms.localToVworldIndex = new int[1][];
            ms.localToVworld[0] = this.localToVworld[0];
            ms.localToVworldIndex[0] = this.localToVworldIndex[0];
            if (s.viewScopedNodeList != null && s.viewLists != null) {
                s.viewScopedNodeList.add(ms);
                s.scopedNodesViewList.add(s.viewLists.get(0));
            } else {
                s.nodeList.add(ms);
            }
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(ms, 3);
            }
            ms.switchState = s.switchStates.get(0);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ms, 3);
                s.notifyThreads |= 0x2000;
            }
        }
        this.dispatchStateChange(1, this.soundData);
        s.notifyThreads |= 0x202;
    }

    @Override
    void clearLive(SetLiveState s) {
        super.clearLive(s);
        if (s.inSharedGroup) {
            for (int i = 0; i < s.keys.length; ++i) {
                SoundRetained ms = this.getMirrorSound(s.keys[i]);
                if (s.switchTargets != null && s.switchTargets[i] != null) {
                    s.switchTargets[i].addNode(ms, 3);
                }
                if (s.transformTargets != null && s.transformTargets[i] != null) {
                    s.transformTargets[i].addNode(ms, 3);
                    s.notifyThreads |= 0x2000;
                }
                if (s.viewScopedNodeList != null && s.viewLists != null) {
                    s.viewScopedNodeList.add(ms);
                    s.scopedNodesViewList.add(s.viewLists.get(i));
                    continue;
                }
                s.nodeList.add(ms);
            }
        } else {
            SoundRetained ms = this.getMirrorSound(null);
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(ms, 3);
            }
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ms, 3);
                s.notifyThreads |= 0x2000;
            }
            if (s.viewScopedNodeList != null && s.viewLists != null) {
                s.viewScopedNodeList.add(ms);
                s.scopedNodesViewList.add(s.viewLists.get(0));
            } else {
                s.nodeList.add(ms);
            }
        }
        s.notifyThreads |= 0x202;
        if (this.soundData != null) {
            ((MediaContainerRetained)this.soundData.retained).clearLive(s.refCount);
        }
    }

    @Override
    void mergeTransform(TransformGroupRetained xform) {
        super.mergeTransform(xform);
        if (this.schedulingRegion != null) {
            this.schedulingRegion.transform(xform.transform);
        }
    }

    @Override
    void updateTransformChange() {
        if (this.boundingLeaf == null && this.schedulingRegion != null) {
            this.transformedRegion = this.schedulingRegion.copy(this.transformedRegion);
            this.transformedRegion.transform(this.schedulingRegion, this.getLastLocalToVworld());
        }
        this.dispatchStateChange(32768, null);
    }

    void debugPrint(String message) {
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        if (key == null) {
            leafList.add(this.mirrorSounds[0]);
        } else {
            for (int i = 0; i < this.numMirrorSounds; ++i) {
                if (!this.mirrorSounds[i].key.equals((Object)key)) continue;
                leafList.add(this.mirrorSounds[i]);
                break;
            }
        }
    }

    static {
        VirtualUniverse.loadLibraries();
    }
}

