/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms.io;

import bdv.util.BoundedRange;
import bigwarp.BigWarp;
import bigwarp.BigwarpSettings;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.source.PlateauSphericalMaskRealRandomAccessible;
import bigwarp.transforms.BigWarpTransform;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

public class TransformWriterJson {
    public static void write(LandmarkTableModel ltm, BigWarpTransform bwTransform, File f) {
        JsonObject transformObj = TransformWriterJson.write(ltm, bwTransform);
        try {
            Path path = Paths.get(f.getCanonicalPath(), new String[0]);
            OpenOption[] options = new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE};
            Writer writer = Channels.newWriter((WritableByteChannel)FileChannel.open(path, options), StandardCharsets.UTF_8.name());
            BigwarpSettings.gson.toJson((JsonElement)transformObj, (Appendable)writer);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void read(File f, BigWarp<?> bw) {
        try {
            Path path = Paths.get(f.getCanonicalPath(), new String[0]);
            OpenOption[] options = new OpenOption[]{StandardOpenOption.READ};
            Reader reader = Channels.newReader((ReadableByteChannel)FileChannel.open(path, options), StandardCharsets.UTF_8.name());
            JsonObject json = (JsonObject)BigwarpSettings.gson.fromJson(reader, JsonObject.class);
            TransformWriterJson.read(bw, json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static JsonObject write(LandmarkTableModel ltm, BigWarpTransform bwTransform) {
        JsonObject transformObj = new JsonObject();
        transformObj.addProperty("type", bwTransform.getTransformType());
        transformObj.add("landmarks", ltm.toJson());
        if (bwTransform.isMasked()) {
            JsonObject maskObj = new JsonObject();
            if (bwTransform.getLambda() instanceof PlateauSphericalMaskRealRandomAccessible) {
                PlateauSphericalMaskRealRandomAccessible mask = (PlateauSphericalMaskRealRandomAccessible)bwTransform.getLambda();
                maskObj.add("parameters", BigwarpSettings.gson.toJsonTree((Object)mask));
            }
            maskObj.add("range", BigwarpSettings.gson.toJsonTree((Object)bwTransform.getMaskIntensityBounds()));
            maskObj.addProperty("interpolationType", bwTransform.getMaskInterpolationType());
            transformObj.add("mask", (JsonElement)maskObj);
        }
        return transformObj;
    }

    public static void read(BigWarp<?> bw, JsonObject json) {
        if (json.has("landmarks")) {
            boolean nonEmpty;
            int nd = json.get("landmarks").getAsJsonObject().get("numDimensions").getAsInt();
            boolean bl = nonEmpty = json.get("landmarks").getAsJsonObject().get("active").getAsJsonArray().size() > 0;
            if (bw.numDimensions() != nd && nonEmpty) {
                bw.changeDimensionality(nd == 2);
            }
            bw.getLandmarkPanel().getTableModel().fromJson((JsonElement)json);
        }
        if (json.has("mask")) {
            JsonObject maskParams = json.get("mask").getAsJsonObject();
            if (maskParams.has("parameters")) {
                bw.addTransformMaskSource();
                JsonObject paramsObj = maskParams.get("parameters").getAsJsonObject();
                PlateauSphericalMaskRealRandomAccessible maskFromJson = (PlateauSphericalMaskRealRandomAccessible)BigwarpSettings.gson.fromJson((JsonElement)paramsObj, PlateauSphericalMaskRealRandomAccessible.class);
                bw.setTransformMaskProperties(maskFromJson.getFallOffShape(), maskFromJson.getSquaredRadius(), maskFromJson.getSquaredSigma(), maskFromJson.getCenter().positionAsDoubleArray());
            } else {
                bw.connectMaskSource();
            }
            bw.setTransformMaskType(maskParams.get("interpolationType").getAsString());
            if (maskParams.has("range")) {
                BoundedRange maskRange = (BoundedRange)BigwarpSettings.gson.fromJson(maskParams.get("range"), BoundedRange.class);
                bw.getBwTransform().setMaskIntensityBounds(maskRange.getMin(), maskRange.getMax());
                bw.setTransformMaskRange(maskRange.getMin(), maskRange.getMax());
            }
        }
        if (json.has("type")) {
            bw.setTransformType(json.get("type").getAsString());
        }
    }
}

