/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.ui.keymap;

import bdv.ui.keymap.AbstractKeymapManager;
import bdv.ui.keymap.Keymap;
import bigwarp.BigWarpActions;
import bigwarp.ui.keymap.DumpInputConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.scijava.Context;
import org.scijava.plugin.PluginService;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionsBuilder;
import org.scijava.ui.behaviour.io.yaml.YamlConfigIO;

public class KeymapManager
extends AbstractKeymapManager<KeymapManager> {
    private static final String CONFIG_DIR_NAME = "keymap/";
    private final String configFile;
    private CommandDescriptions descriptions;
    private static List<Keymap> loadedBuiltinStyles;

    public KeymapManager(String configDir) {
        this(true, configDir);
        this.discoverCommandDescriptions();
    }

    public KeymapManager() {
        this(false, null);
    }

    private KeymapManager(boolean loadStyles, String configDir) {
        String string = this.configFile = configDir == null ? null : configDir + "/" + CONFIG_DIR_NAME;
        if (loadStyles) {
            this.loadStyles();
        }
    }

    public synchronized void setCommandDescriptions(CommandDescriptions descriptions) {
        this.descriptions = descriptions;
        Consumer<Keymap> augmentInputTriggerConfig = k -> descriptions.augmentInputTriggerConfig(k.getConfig());
        this.builtinStyles.forEach(augmentInputTriggerConfig);
        this.userStyles.forEach(augmentInputTriggerConfig);
    }

    public CommandDescriptions getCommandDescriptions() {
        return this.descriptions;
    }

    public synchronized void discoverCommandDescriptions() {
        CommandDescriptionsBuilder builder = new CommandDescriptionsBuilder();
        Context context = new Context(new Class[]{PluginService.class});
        context.inject((Object)builder);
        builder.discoverProviders(new CommandDescriptionProvider.Scope[]{BigWarpActions.BIGWARP});
        context.dispose();
        this.setCommandDescriptions(builder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Keymap> loadBuiltinStyles() {
        Class<KeymapManager> clazz = KeymapManager.class;
        synchronized (KeymapManager.class) {
            if (loadedBuiltinStyles == null) {
                try {
                    loadedBuiltinStyles = Arrays.asList(KeymapManager.loadBuiltinStyle("Default", "default.yaml"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    loadedBuiltinStyles = Arrays.asList(KeymapManager.createDefaultStyle("Default"));
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return loadedBuiltinStyles;
        }
    }

    protected void loadStyles(File directory) throws IOException {
        File file = new File(directory, "/keymaps.yaml");
        boolean keymapFileExists = file.exists();
        super.loadStyles(directory);
        if (!keymapFileExists) {
            this.saveStyles(directory);
        }
    }

    private static Keymap loadBuiltinStyle(String name, String filename) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(KeymapManager.class.getResourceAsStream(filename));){
            Keymap keymap = new Keymap(name, new InputTriggerConfig((Collection)YamlConfigIO.read((Reader)reader)));
            return keymap;
        }
    }

    private static Keymap createDefaultStyle(String name) {
        Context context = new Context(new Class[]{PluginService.class});
        InputTriggerConfig defaultKeyconfig = DumpInputConfig.buildCommandDescriptions(context).createDefaultKeyconfig();
        return new Keymap(name, defaultKeyconfig);
    }

    public void loadStyles() {
        try {
            this.loadStyles(new File(this.configFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void saveStyles() {
        try {
            this.saveStyles(new File(this.configFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

