/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import bdv.util.Affine3DHelpers;
import bdv.viewer.animate.AbstractTransformAnimator;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;

public class SimilarityTransformInterpolator
extends AbstractTransformAnimator {
    private final double[] qStart;
    private final double[] qDiff;
    private final double scaleStart;
    private final double scaleEnd;
    private final double scaleRate;
    private final double[] p;
    private final double[] pDiff;

    public SimilarityTransformInterpolator(AffineTransform3D transform, double[] p) {
        super(1L);
        AffineTransform3D transformEnd = new AffineTransform3D();
        transformEnd.set(transform);
        this.p = p;
        this.qStart = new double[]{1.0, 0.0, 0.0, 0.0};
        double[] qStartInv = new double[4];
        double[] qEnd = new double[4];
        double[] qEndInv = new double[4];
        this.qDiff = new double[4];
        LinAlgHelpers.quaternionInvert((double[])this.qStart, (double[])qStartInv);
        Affine3DHelpers.extractRotation((AffineTransform3D)transformEnd, (double[])qEnd);
        LinAlgHelpers.quaternionInvert((double[])qEnd, (double[])qEndInv);
        LinAlgHelpers.quaternionMultiply((double[])qStartInv, (double[])qEnd, (double[])this.qDiff);
        if (this.qDiff[0] < 0.0) {
            LinAlgHelpers.scale((double[])this.qDiff, (double)-1.0, (double[])this.qDiff);
        }
        this.scaleStart = 1.0;
        this.scaleEnd = Affine3DHelpers.extractScale((AffineTransform3D)transformEnd, (int)0);
        this.scaleRate = this.scaleEnd / this.scaleStart;
        this.pDiff = new double[3];
        double[] tmp = new double[3];
        this.get(1.0).apply(p, tmp);
        transform.apply(p, this.pDiff);
        LinAlgHelpers.subtract((double[])this.pDiff, (double[])tmp, (double[])this.pDiff);
    }

    public AffineTransform3D get(double t) {
        double[] qDiffCurrent = new double[4];
        double[] qCurrent = new double[4];
        LinAlgHelpers.quaternionPower((double[])this.qDiff, (double)t, (double[])qDiffCurrent);
        LinAlgHelpers.quaternionMultiply((double[])this.qStart, (double[])qDiffCurrent, (double[])qCurrent);
        double alpha = Math.pow(this.scaleRate, t);
        double scaleCurrent = this.scaleStart * alpha;
        double[][] Rcurrent = new double[3][3];
        LinAlgHelpers.quaternionToR((double[])qCurrent, (double[][])Rcurrent);
        double[][] m = new double[3][4];
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                m[r][c] = scaleCurrent * Rcurrent[r][c];
            }
        }
        AffineTransform3D transform = new AffineTransform3D();
        transform.set(m);
        double[] pCurrent = new double[3];
        transform.apply(this.p, pCurrent);
        double[] pTgt = new double[3];
        LinAlgHelpers.scale((double[])this.pDiff, (double)t, (double[])pTgt);
        LinAlgHelpers.add((double[])this.p, (double[])pTgt, (double[])pTgt);
        LinAlgHelpers.subtract((double[])pTgt, (double[])pCurrent, (double[])pTgt);
        transform.translate(pTgt);
        return transform;
    }
}

