/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.minimaven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.scijava.minimaven.AbstractPOMHandler;
import org.scijava.minimaven.Coordinate;
import org.scijava.minimaven.JavaCompiler;
import org.scijava.minimaven.MavenProject;
import org.scijava.minimaven.ReadInto;
import org.scijava.minimaven.SnapshotPOMHandler;
import org.scijava.minimaven.VersionPOMHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class BuildEnvironment {
    public static final String IMAGEJ_APP_DIRECTORY = "imagej.app.directory";
    protected String endLine = BuildEnvironment.isInteractiveConsole() ? "\u001b[K\r" : "\n";
    protected boolean verbose;
    protected boolean debug = false;
    protected boolean downloadAutomatically;
    protected boolean offlineMode;
    protected boolean ignoreMavenRepositories;
    protected int updateInterval = 1440;
    protected PrintStream err;
    protected JavaCompiler javac;
    protected Map<String, MavenProject> localPOMCache = new HashMap<String, MavenProject>();
    protected Map<File, MavenProject> file2pom = new HashMap<File, MavenProject>();
    protected Stack<File> multiProjectRoots = new Stack();
    protected Set<File> excludedFromMultiProjects = new HashSet<File>();
    protected static final File mavenRepository;
    private static final boolean isWindows;

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getDownloadAutomatically() {
        return this.downloadAutomatically && !this.offlineMode;
    }

    protected static boolean isInteractiveConsole() {
        try {
            return null != System.class.getMethod("console", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            return false;
        }
    }

    public BuildEnvironment(PrintStream err, boolean downloadAutomatically, boolean verbose, boolean debug) {
        String updateInterval;
        this.err = err == null ? System.err : err;
        this.javac = new JavaCompiler(this.err, this.err);
        this.downloadAutomatically = downloadAutomatically;
        this.verbose = verbose;
        this.debug = debug;
        if ("true".equalsIgnoreCase(System.getProperty("minimaven.offline"))) {
            this.offlineMode = true;
        }
        if ("ignore".equalsIgnoreCase(System.getProperty("minimaven.repositories"))) {
            this.ignoreMavenRepositories = true;
        }
        if ((updateInterval = System.getProperty("minimaven.updateinterval")) != null && !updateInterval.equals("")) {
            try {
                this.updateInterval = Integer.parseInt(updateInterval);
                if (verbose) {
                    this.err.println("Setting update interval to " + this.updateInterval + " minutes");
                }
            }
            catch (NumberFormatException e) {
                this.err.println("Warning: ignoring invalid update interval " + updateInterval);
            }
        }
    }

    public PrintStream getErr() {
        return this.err;
    }

    protected void print80(String string) {
        int length = string.length();
        this.err.print((this.verbose || length < 80 ? string : string.substring(0, 80)) + this.endLine);
    }

    public MavenProject parse(File file) throws IOException, ParserConfigurationException, SAXException {
        return this.parse(file, null);
    }

    public MavenProject parse(File file, MavenProject parent) throws IOException, ParserConfigurationException, SAXException {
        return this.parse(file, parent, null);
    }

    public MavenProject parse(File file, MavenProject parent, String classifier) throws IOException, ParserConfigurationException, SAXException {
        if (this.file2pom.containsKey(file)) {
            MavenProject result = this.file2pom.get(file);
            if (classifier == null ? result.coordinate.classifier == null : classifier.equals(result.coordinate.classifier)) {
                return result;
            }
        }
        if (!file.exists()) {
            return null;
        }
        if (this.verbose) {
            this.print80("Parsing " + file);
        }
        File directory = file.getCanonicalFile().getParentFile();
        MavenProject pom = this.parse(new FileInputStream(file), directory, parent, classifier);
        this.file2pom.put(file, pom);
        return pom;
    }

    public MavenProject parse(InputStream in, File directory, MavenProject parent, String classifier) throws SAXException, ParserConfigurationException, IOException {
        String key;
        MavenProject pom = new MavenProject(this, directory, parent);
        pom.coordinate.classifier = classifier;
        if (parent != null) {
            pom.sourceDirectory = parent.sourceDirectory;
            pom.includeImplementationBuild = parent.includeImplementationBuild;
        }
        pom.parse(in);
        if (pom.coordinate.artifactId == null || pom.coordinate.artifactId.equals("")) {
            throw new SAXException("Missing artifactId: " + new File(directory, "pom.xml"));
        }
        if (pom.coordinate.groupId == null || pom.coordinate.groupId.equals("")) {
            throw new SAXException("Missing groupId: " + new File(directory, "pom.xml"));
        }
        String version = pom.coordinate.getVersion();
        if (version == null || version.equals("")) {
            throw new SAXException("Missing version: " + new File(directory, "pom.xml"));
        }
        pom.children = new MavenProject[pom.modules.size()];
        for (int i = 0; i < pom.children.length; ++i) {
            File child = new File(directory, pom.modules.get(i) + "/pom.xml");
            pom.children[i] = this.parse(child, pom);
        }
        if (pom.target == null) {
            String fileName = pom.coordinate.getJarName();
            pom.target = new File(directory, fileName);
        }
        if (!this.localPOMCache.containsKey(key = pom.expand(pom.coordinate).getKey())) {
            this.localPOMCache.put(key, pom);
        }
        if (pom.isJAR() && !directory.getPath().startsWith(mavenRepository.getPath())) {
            pom.buildFromSource = true;
            pom.target = new File(directory, "target/classes");
        }
        if (pom.parentCoordinate != null && pom.parent == null) {
            Coordinate dependency = pom.expand(pom.parentCoordinate);
            pom.parent = pom.findPOM(dependency, true, false);
            if (pom.parent == null) {
                File parentFile;
                File parentDirectory = pom.directory.getParentFile();
                if (parentDirectory == null) {
                    try {
                        parentDirectory = pom.directory.getCanonicalFile().getParentFile();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (parentDirectory != null && (parentFile = new File(parentDirectory, "pom.xml")).exists()) {
                    pom.parent = this.parse(parentFile, null, null);
                }
            }
            if (pom.parent == null && this.downloadAutomatically && pom.maybeDownloadAutomatically(pom.parentCoordinate, !this.verbose, this.downloadAutomatically)) {
                pom.parent = pom.findPOM(dependency, !this.verbose, this.downloadAutomatically);
            }
            if (pom.parent == null) {
                throw new RuntimeException("Parent not found: " + pom.parentCoordinate + (this.downloadAutomatically ? "" : " (please call MiniMaven's 'download'"));
            }
            if (pom.parent.parent == pom) {
                pom.parent.parent = null;
            }
            if (pom.parent.includeImplementationBuild) {
                pom.includeImplementationBuild = true;
            }
            pom.parent.addChild(pom);
        }
        return pom;
    }

    public MavenProject fakePOM(File target, Coordinate dependency) {
        MavenProject pom = new MavenProject(this, target, null);
        pom.directory = target.getParentFile();
        pom.target = target;
        pom.children = new MavenProject[0];
        pom.coordinate = dependency;
        if (dependency.artifactId.equals("ij")) {
            String javac = pom.expand("${java.home}/../lib/tools.jar");
            if (new File(javac).exists()) {
                pom.dependencies.add(new Coordinate("com.sun", "tools", "1.4.2", null, false, javac, null, null));
            }
        } else if (dependency.artifactId.equals("imglib2-io")) {
            pom.dependencies.add(new Coordinate("loci", "bio-formats", "${bio-formats.version}"));
        } else if (dependency.artifactId.equals("jfreechart")) {
            pom.dependencies.add(new Coordinate("jfree", "jcommon", "1.0.17"));
        }
        String key = dependency.getKey();
        if (this.debug && this.localPOMCache.containsKey(key)) {
            this.err.println("Warning: " + target + " overrides " + this.localPOMCache.get(key));
        }
        this.localPOMCache.put(key, pom);
        return pom;
    }

    public boolean containsProject(String groupId, String artifactId) {
        return this.containsProject(new Coordinate(groupId, artifactId, null));
    }

    public boolean containsProject(Coordinate coordinate) {
        return this.localPOMCache.containsKey(coordinate.getKey());
    }

    public void addMultiProjectRoot(File root) {
        try {
            this.multiProjectRoots.push(root.getCanonicalFile());
        }
        catch (IOException e) {
            this.multiProjectRoots.push(root);
        }
    }

    public void excludeFromMultiProjects(File directory) {
        try {
            this.excludedFromMultiProjects.add(directory.getCanonicalFile());
        }
        catch (IOException e) {
            this.excludedFromMultiProjects.add(directory);
        }
    }

    public void parseMultiProjects() throws IOException, ParserConfigurationException, SAXException {
        while (!this.multiProjectRoots.empty()) {
            Object[] list;
            File root = this.multiProjectRoots.pop();
            if (root == null || !root.exists() || (list = root.listFiles()) == null) continue;
            Arrays.sort(list);
            for (Object directory : list) {
                File file;
                if (this.excludedFromMultiProjects.contains(directory) || !(file = new File((File)directory, "pom.xml")).exists()) continue;
                this.parse(file, null);
            }
        }
    }

    protected void downloadAndVerify(String repositoryURL, Coordinate dependency, boolean quiet) throws MalformedURLException, IOException, NoSuchAlgorithmException, ParserConfigurationException, SAXException {
        String message;
        String path = "/" + dependency.groupId.replace('.', '/') + "/" + dependency.artifactId + "/" + dependency.version + "/";
        File directory = new File(mavenRepository, path);
        if (dependency.version.endsWith("-SNAPSHOT")) {
            File snapshotMetaData = new File(directory, "maven-metadata-snapshot.xml");
            if (System.currentTimeMillis() - snapshotMetaData.lastModified() < (long)(this.updateInterval * 60) * 1000L) {
                return;
            }
            message = quiet ? null : "Checking for new snapshot of " + dependency.artifactId;
            String metadataURL = repositoryURL + path + "maven-metadata.xml";
            this.downloadAndVerify(metadataURL, directory, snapshotMetaData.getName(), message);
            String snapshotVersion = SnapshotPOMHandler.parse(snapshotMetaData);
            if (snapshotVersion == null) {
                throw new IOException("No version found in " + metadataURL);
            }
            dependency.setSnapshotVersion(snapshotVersion);
            if (new File(directory, dependency.getJarName()).exists() && new File(directory, dependency.getPOMName()).exists()) {
                return;
            }
        } else if (dependency.version.startsWith("[")) {
            path = "/" + dependency.groupId.replace('.', '/') + "/" + dependency.artifactId + "/";
            directory = new File(mavenRepository, path);
            File versionMetaData = new File(directory, "maven-metadata-version.xml");
            if (System.currentTimeMillis() - versionMetaData.lastModified() < (long)(this.updateInterval * 60) * 1000L) {
                return;
            }
            message = quiet ? null : "Checking for new version of " + dependency.artifactId;
            String metadataURL = repositoryURL + path + "maven-metadata.xml";
            this.downloadAndVerify(metadataURL, directory, versionMetaData.getName(), message);
            dependency.snapshotVersion = VersionPOMHandler.parse(versionMetaData);
            if (dependency.snapshotVersion == null) {
                throw new IOException("No version found in " + metadataURL);
            }
            path = "/" + dependency.groupId.replace('.', '/') + "/" + dependency.artifactId + "/" + dependency.snapshotVersion + "/";
            directory = new File(mavenRepository, path);
            if (new File(directory, dependency.getJarName()).exists() && new File(directory, dependency.getPOMName()).exists()) {
                return;
            }
        }
        String message2 = quiet ? null : "Downloading " + dependency.artifactId;
        String baseURL = repositoryURL + path;
        this.downloadAndVerify(baseURL + dependency.getPOMName(), directory, null);
        if (!this.isAggregatorPOM(new File(directory, dependency.getPOMName()))) {
            this.downloadAndVerify(baseURL + dependency.getJarName(), directory, message2);
        }
    }

    protected void downloadAndVerify(String url, File directory, String message) throws IOException, NoSuchAlgorithmException {
        this.downloadAndVerify(url, directory, null, message);
    }

    protected void downloadAndVerify(String url, File directory, String fileName, String message) throws IOException, NoSuchAlgorithmException {
        if (fileName == null) {
            fileName = url.substring(url.lastIndexOf(47) + 1);
        }
        File sha1 = this.download(new URL(url + ".sha1"), directory, fileName + ".sha1.new", null);
        File file = this.download(new URL(url), directory, fileName + ".new", message);
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        FileInputStream fileStream = new FileInputStream(file);
        DigestInputStream digestStream = new DigestInputStream(fileStream, digest);
        byte[] buffer = new byte[131072];
        while (digestStream.read(buffer) >= 0) {
        }
        digestStream.close();
        byte[] digestBytes = digest.digest();
        fileStream = new FileInputStream(sha1);
        for (int i = 0; i < digestBytes.length; ++i) {
            int d;
            int value = BuildEnvironment.hexNybble(fileStream.read()) << 4 | BuildEnvironment.hexNybble(fileStream.read());
            if (value == (d = digestBytes[i] & 0xFF)) continue;
            String actual = "";
            for (byte b : digestBytes) {
                actual = actual + String.format("%02x", b & 0xFF);
            }
            fileStream.close();
            throw new IOException("SHA1 mismatch: " + sha1 + ": " + Integer.toHexString(value) + " != " + Integer.toHexString(d) + " (actual SHA-1: " + actual + ")");
        }
        fileStream.close();
        this.rename(file, new File(directory, fileName));
        this.rename(sha1, new File(directory, fileName + ".sha1"));
    }

    protected void rename(File source, File target) throws IOException {
        if (isWindows && target.exists() && !target.delete()) {
            throw new IOException("Could not delete " + target);
        }
        if (!source.renameTo(target)) {
            throw new IOException("Could not rename " + source + " to " + target);
        }
    }

    protected boolean isAggregatorPOM(File xml) {
        if (!xml.exists()) {
            return false;
        }
        try {
            return this.isAggregatorPOM(new FileInputStream(xml));
        }
        catch (IOException e) {
            e.printStackTrace(this.err);
            return false;
        }
    }

    protected boolean isAggregatorPOM(InputStream in) {
        final RuntimeException yes = new RuntimeException();
        final RuntimeException no = new RuntimeException();
        try {
            AbstractPOMHandler handler = new AbstractPOMHandler(){
                protected int level = 0;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    super.startElement(uri, localName, qName, attributes);
                    if (this.level == 0 && "project".equals(qName) || this.level == 1 && "packaging".equals(qName)) {
                        ++this.level;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    super.endElement(uri, localName, qName);
                    if (this.level == 1 && "project".equals(qName) || this.level == 2 && "packaging".equals(qName)) {
                        --this.level;
                    }
                }

                @Override
                public void processCharacters(StringBuilder sb) {
                    if (this.level == 2) {
                        throw "pom".equals(sb.toString()) ? yes : no;
                    }
                }
            };
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(in));
            in.close();
            return false;
        }
        catch (Exception e) {
            try {
                in.close();
            }
            catch (IOException e2) {
                e2.printStackTrace(this.err);
            }
            if (e == yes) {
                return true;
            }
            if (e == no) {
                return false;
            }
            e.printStackTrace(this.err);
            return false;
        }
    }

    protected static int hexNybble(int b) {
        return (b < 65 ? (b < 97 ? b - 48 : b - 97 + 10) : b - 65 + 10) & 0xF;
    }

    protected static void rmRF(File directory) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                BuildEnvironment.rmRF(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    protected File download(URL url, File directory, String message) throws IOException {
        return this.download(url, directory, null, message);
    }

    protected File download(URL url, File directory, String fileName, String message) throws IOException {
        URLConnection connection;
        String name;
        if (this.offlineMode) {
            throw new RuntimeException("Offline!");
        }
        if (this.verbose) {
            this.err.println("Trying to download " + url);
        }
        if ((name = fileName) == null) {
            name = url.getPath();
            name = name.substring(name.lastIndexOf(47) + 1);
        }
        if ((connection = url.openConnection()) instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)connection;
            http.setRequestProperty("User-Agent", "MiniMaven/2.0.0-SNAPSHOT");
        }
        InputStream in = connection.getInputStream();
        if (message != null) {
            this.err.println(message);
        }
        directory.mkdirs();
        File result = new File(directory, name);
        if (this.verbose) {
            this.err.println("Downloading " + url + " to " + result.getAbsolutePath());
        }
        BuildEnvironment.copy(in, result);
        return result;
    }

    public static void copyFile(File source, File target) throws IOException {
        BuildEnvironment.copy(new FileInputStream(source), target);
    }

    public static void copy(InputStream in, File target) throws IOException {
        BuildEnvironment.copy(in, new FileOutputStream(target), true);
    }

    public static void copy(InputStream in, OutputStream out, boolean closeOutput) throws IOException {
        int count;
        byte[] buffer = new byte[131072];
        while ((count = in.read(buffer)) >= 0) {
            out.write(buffer, 0, count);
        }
        in.close();
        if (closeOutput) {
            out.close();
        }
    }

    protected static boolean isSnapshotVersion(String version) {
        return version != null && version.endsWith("-SNAPSHOT");
    }

    protected static boolean isTimestampVersion(String version) {
        return version != null && version.matches("2\\d{7,13}");
    }

    protected static int compareVersion(String version1, String version2) {
        if (version1 == null) {
            return version2 == null ? 0 : -1;
        }
        if (version1.equals(version2)) {
            return 0;
        }
        if (BuildEnvironment.isTimestampVersion(version1) && BuildEnvironment.isSnapshotVersion(version2)) {
            return -1;
        }
        if (BuildEnvironment.isSnapshotVersion(version1) && BuildEnvironment.isTimestampVersion(version2)) {
            return 1;
        }
        String[] split1 = version1.split("\\.");
        String[] split2 = version2.split("\\.");
        int i = 0;
        while (i != split1.length) {
            int result;
            int end2;
            if (i == split2.length) {
                return 1;
            }
            int end1 = BuildEnvironment.firstNonDigit(split1[i]);
            if (end1 != (end2 = BuildEnvironment.firstNonDigit(split2[i]))) {
                return end1 - end2;
            }
            int n = result = end1 == 0 ? 0 : Integer.parseInt(split1[i].substring(0, end1)) - Integer.parseInt(split2[i].substring(0, end2));
            if (result != 0) {
                return result;
            }
            result = split1[i].substring(end1).compareTo(split2[i].substring(end2));
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return i == split2.length ? 0 : -1;
    }

    protected static int firstNonDigit(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return i;
        }
        return length;
    }

    protected String getImplementationBuild(File fileOrDirectory) {
        File file = fileOrDirectory;
        if (!file.isAbsolute()) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException e) {
                file = file.getAbsoluteFile();
            }
        }
        do {
            File gitDir;
            if (!(gitDir = new File(file, ".git")).exists()) continue;
            return this.exec(gitDir.getParentFile(), "git", "rev-parse", "HEAD");
        } while ((file = file.getParentFile()) != null);
        return null;
    }

    protected String exec(File gitDir, String ... args) {
        try {
            Process process = Runtime.getRuntime().exec(args, null, gitDir);
            process.getOutputStream().close();
            ReadInto err = new ReadInto(process.getErrorStream(), this.err);
            ReadInto out = new ReadInto(process.getInputStream(), null);
            try {
                process.waitFor();
                err.join();
                out.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (process.exitValue() != 0) {
                throw new RuntimeException("Error executing " + Arrays.toString(args) + "\n" + err);
            }
            return out.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        File repository = new File(System.getProperty("user.home"), ".m2/repository");
        try {
            repository = repository.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mavenRepository = repository;
        String osName = System.getProperty("os.name").toLowerCase();
        isWindows = osName.startsWith("win");
    }
}

