/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbridges.objectinspector;

import com.github.sbridges.objectinspector.ArrayNode;
import com.github.sbridges.objectinspector.CollectionNode;
import com.github.sbridges.objectinspector.FieldValue;
import com.github.sbridges.objectinspector.InspectorNode;
import com.github.sbridges.objectinspector.MapNode;
import com.github.sbridges.objectinspector.NotAccessibleNode;
import com.github.sbridges.objectinspector.ObjectNode;
import com.github.sbridges.objectinspector.PrimitiveNode;
import com.github.sbridges.objectinspector.SimpleValue;
import com.github.sbridges.objectinspector.Value;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreeNode;

abstract class ComplexNode
implements InspectorNode {
    private InspectorNode parent;
    private Class parentClass;
    private Vector children = new Vector(0);
    private String name;

    public static final InspectorNode createInspectorTree(Object obj) {
        if (obj == null) {
            return new ObjectNode("<null>", null);
        }
        return ComplexNode.createComplexNode(new SimpleValue(obj), null, obj.getClass().getName());
    }

    protected static final InspectorNode createNode(Field field, InspectorNode parent, Value value) {
        return ComplexNode.createNode(field, parent, value, "");
    }

    protected static final InspectorNode createNode(Field field, InspectorNode parent, Value value, String prefix) {
        String name = prefix + field.getName();
        if (name.length() < 15) {
            name = name + "            ";
        }
        try {
            field.setAccessible(true);
        }
        catch (SecurityException e) {
            return new NotAccessibleNode(parent, name);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Complex node could not create a node");
        }
        Class<?> c = field.getType();
        if (c.isPrimitive()) {
            return new PrimitiveNode(parent, new FieldValue(value, field), name);
        }
        return ComplexNode.createComplexNode(new FieldValue(value, field), parent, name);
    }

    protected static final InspectorNode createComplexNode(Value value, InspectorNode parent, String name) {
        Object nextObject = value.getValue();
        if (nextObject == null) {
            return new ObjectNode(value, name, parent);
        }
        Class<?> theClass = nextObject.getClass();
        if (theClass.isArray()) {
            return new ArrayNode(parent, value, name);
        }
        if (nextObject != null && nextObject instanceof Collection) {
            return new CollectionNode(value, name, parent);
        }
        if (nextObject != null && nextObject instanceof Map) {
            return new MapNode(value, name, parent);
        }
        return new ObjectNode(value, name, parent);
    }

    ComplexNode(InspectorNode parent, String name) {
        Object parentValue;
        this.parent = parent;
        if (parent != null && (parentValue = parent.getValue()) != null) {
            this.parentClass = parentValue.getClass();
        }
        this.name = name;
    }

    protected abstract InspectorNode generateChild(int var1);

    protected void setNumberOfChildren(int numberOfChildren) {
        this.children.setSize(numberOfChildren);
    }

    protected int getNumberOfChildren() {
        return this.children.size();
    }

    public Enumeration children() {
        return this.children.elements();
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int childIndex) {
        InspectorNode child = (InspectorNode)this.children.get(childIndex);
        if (child == null) {
            child = this.generateChild(childIndex);
            this.children.setElementAt(child, childIndex);
        }
        return child;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isLeaf() {
        return this.children.size() == 0;
    }

    public boolean isValid() {
        if (this.parent == null) {
            return true;
        }
        if (!this.parent.isValid()) {
            return false;
        }
        Object parentValue = this.parent.getValue();
        if (parentValue == null) {
            return this.parentClass == null;
        }
        return parentValue.getClass() == this.parentClass;
    }

    public String toString() {
        return this.name;
    }

    public String debugString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toString());
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            InspectorNode n = (InspectorNode)e.nextElement();
            buf.append("\n  ");
            buf.append(n.toString());
            buf.append(" ");
            buf.append(n.getValueString());
        }
        return buf.toString();
    }
}

