/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import volume.Volume;

public class VolumeInteger
extends Volume {
    public int[][][] v;

    public VolumeInteger() {
        this(0, 0, 0);
    }

    public VolumeInteger(int width, int height, int depth) {
        this(width, height, depth, 1.0, 1.0, 1.0);
    }

    public VolumeInteger(int width, int height, int depth, double aspectx, double aspecty, double aspectz) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.v = new int[depth][height][width];
        this.setAspects(aspectx, aspecty, aspectz);
        this.edge = 0;
    }

    public VolumeInteger(ImageStack s, double aspectx, double aspecty, double aspectz) {
        this(s.getWidth(), s.getHeight(), s.getSize(), aspectx, aspecty, aspectz);
        this.load(s, 0);
    }

    public VolumeInteger(ImageStack s) {
        this(s, 1.0, 1.0, 1.0);
    }

    public VolumeInteger(ImageProcessor ip) {
        this(ip.getWidth(), ip.getHeight(), 1, 1.0, 1.0, 1.0);
        this.load(ip, 0);
    }

    public VolumeInteger(ImageStack s, int depth, int n) {
        this(s, depth, n, 1.0, 1.0, 1.0);
    }

    public VolumeInteger(ImageStack s, int depth, int n, double aspectx, double aspecty, double aspectz) {
        this(s.getWidth(), s.getHeight(), depth, aspectx, aspecty, aspectz);
        this.load(s, n * depth);
    }

    public int[][][] getVolume() {
        return this.v;
    }

    @Override
    public Object get(int x, int y, int z) {
        return new Integer(this.v[z][y][x]);
    }

    @Override
    public void set(Object i, int x, int y, int z) {
        this.v[z][y][x] = (Integer)i;
    }

    public void load(ImageStack s, int start) {
        for (int t = start; t < start + this.depth; ++t) {
            this.loadSlice(this.v[t - start], s, t + 1);
        }
    }

    public void load(ImageProcessor ip, int t) {
        if (ip instanceof ByteProcessor) {
            this.loadImage(this.v[t], (byte[])ip.getPixels());
        } else if (ip instanceof FloatProcessor) {
            this.loadImage(this.v[t], (int[])ip.getPixels());
        } else {
            IJ.error((String)"load: image type not supported.");
        }
    }

    public void loadInverse(ImageStack s, int center) {
        for (int t = -this.depth / 2; t <= this.depth / 2; ++t) {
            int[][] t1 = new int[this.height][this.width];
            this.loadSlice(t1, s, center + this.depth / 2 - t);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t + this.depth / 2][y][x] = t1[y][x];
                }
            }
        }
    }

    protected void loadSlice(int[][] i, ImageStack s, int io) {
        if (io < 1 || io > s.getSize()) {
            IJ.error((String)("loadSlice: slice index out of bounds (" + io + "><1-" + s.getSize() + ")"));
            return;
        }
        Object[] stack = s.getImageArray();
        if (stack[0] instanceof byte[]) {
            this.loadImage(i, (byte[])s.getPixels(io));
        } else if (stack[0] instanceof int[]) {
            this.loadImage(i, (int[])s.getPixels(io));
        } else {
            IJ.error((String)"loadSlice: image type not supported.");
        }
    }

    protected void loadImage(int[][] i, byte[] b) {
        for (int y = 0; y < this.height; ++y) {
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                i[y][x] = b[offset + x] & 0xFF;
            }
        }
    }

    protected void loadImage(int[][] i, int[] sh) {
        for (int y = 0; y < this.height; ++y) {
            int offset = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                i[y][x] = sh[offset + x];
            }
        }
    }
}

