/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.legacy;

import java.util.HashMap;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.legacy.LegacyImgLoader;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SetupImgLoader;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.real.FloatType;

public class LegacyImgLoaderWrapper<T, I extends LegacyImgLoader<T>>
implements ImgLoader {
    protected final I legacyImgLoader;
    private final HashMap<Integer, SetupImgLoaderWrapper> setupImgLoaders;

    public LegacyImgLoaderWrapper(I legacyImgLoader) {
        this.legacyImgLoader = legacyImgLoader;
        this.setupImgLoaders = new HashMap();
    }

    @Override
    public synchronized SetupImgLoaderWrapper getSetupImgLoader(int setupId) {
        SetupImgLoaderWrapper sil = this.setupImgLoaders.get(setupId);
        if (sil == null) {
            sil = new SetupImgLoaderWrapper(setupId);
            this.setupImgLoaders.put(setupId, sil);
        }
        return sil;
    }

    public class SetupImgLoaderWrapper
    implements SetupImgLoader<T> {
        private final int setupId;

        protected SetupImgLoaderWrapper(int setupId) {
            this.setupId = setupId;
        }

        @Override
        public RandomAccessibleInterval<T> getImage(int timepointId, ImgLoaderHint ... hints) {
            return LegacyImgLoaderWrapper.this.legacyImgLoader.getImage(new ViewId(timepointId, this.setupId));
        }

        @Override
        public T getImageType() {
            return LegacyImgLoaderWrapper.this.legacyImgLoader.getImageType();
        }

        @Override
        public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, boolean normalize, ImgLoaderHint ... hints) {
            return LegacyImgLoaderWrapper.this.legacyImgLoader.getFloatImage(new ViewId(timepointId, this.setupId), normalize);
        }

        @Override
        public Dimensions getImageSize(int timepointId) {
            return LegacyImgLoaderWrapper.this.legacyImgLoader.getImageSize(new ViewId(timepointId, this.setupId));
        }

        @Override
        public VoxelDimensions getVoxelSize(int timepointId) {
            return LegacyImgLoaderWrapper.this.legacyImgLoader.getVoxelSize(new ViewId(timepointId, this.setupId));
        }
    }
}

