/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import mpicbg.trakem2.transform.InvertibleCoordinateTransform;

public class HomographyModel2D
extends mpicbg.models.HomographyModel2D
implements InvertibleCoordinateTransform {
    private static final long serialVersionUID = 3098424136915475353L;

    @Override
    public void init(String data) throws NumberFormatException {
        String[] fields = data.split("\\s+");
        if (fields.length != 9) {
            throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        }
        double m00 = Double.parseDouble(fields[0]);
        double m01 = Double.parseDouble(fields[1]);
        double m02 = Double.parseDouble(fields[2]);
        double m10 = Double.parseDouble(fields[3]);
        double m11 = Double.parseDouble(fields[4]);
        double m12 = Double.parseDouble(fields[5]);
        double m20 = Double.parseDouble(fields[6]);
        double m21 = Double.parseDouble(fields[7]);
        double m22 = Double.parseDouble(fields[8]);
        this.set(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    @Override
    public String toDataString() {
        return this.m00 + " " + this.m01 + " " + this.m02 + " " + this.m10 + " " + this.m11 + " " + this.m12 + " " + this.m20 + " " + this.m21 + " " + this.m22 + " ";
    }

    @Override
    public String toXML(String indent) {
        return indent + "<iict_transform class=\"" + this.getClass().getCanonicalName() + "\" data=\"" + this.toDataString() + "\" />";
    }

    @Override
    public HomographyModel2D copy() {
        HomographyModel2D m = new HomographyModel2D();
        m.set(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        return m;
    }
}

