/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractPlane;
import io.scif.ImageMetadata;
import io.scif.gui.AWTImageTools;
import java.awt.image.BufferedImage;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.util.Intervals;
import org.scijava.util.Bytes;

public class BufferedImagePlane
extends AbstractPlane<BufferedImage, BufferedImagePlane> {
    byte[] cachedBytes = null;

    public BufferedImagePlane() {
    }

    public BufferedImagePlane(ImageMetadata meta, Interval bounds) {
        super(meta, bounds);
    }

    @Override
    public byte[] getBytes() {
        if (this.cachedBytes == null) {
            switch (((BufferedImage)this.getData()).getColorModel().getComponentSize(0)) {
                case 8: {
                    this.cachedBytes = AWTImageTools.getBytes((BufferedImage)this.getData(), false);
                    break;
                }
                case 16: {
                    short[][] ts = AWTImageTools.getShorts((BufferedImage)this.getData());
                    this.cachedBytes = new byte[ts.length * ts[0].length * 2];
                    for (int c = 0; c < ts.length; ++c) {
                        int offset = c * ts[c].length * 2;
                        for (int i = 0; i < ts[c].length; ++i) {
                            Bytes.unpack((long)ts[c][i], (byte[])this.cachedBytes, (int)offset, (int)2, (boolean)this.getImageMetadata().isLittleEndian());
                            offset += 2;
                        }
                    }
                    break;
                }
            }
        }
        return this.cachedBytes;
    }

    @Override
    protected BufferedImage blankPlane(Interval bounds) {
        int type = this.getImageMetadata().getPixelType();
        return AWTImageTools.blankImage(this.getImageMetadata(), Intervals.dimensionsAsLongArray((Dimensions)bounds), type);
    }

    @Override
    public void setData(BufferedImage data) {
        super.setData(data);
        this.cachedBytes = null;
    }
}

