/*
 * Decompiled with CFR 0.152.
 */
package io.scif.codec;

import io.scif.DependencyException;
import io.scif.FormatException;
import io.scif.MissingLibraryException;
import io.scif.UnsupportedCompressionException;
import io.scif.codec.AbstractCodec;
import io.scif.codec.Codec;
import io.scif.codec.CodecOptions;
import io.scif.services.LuraWaveService;
import io.scif.services.ServiceException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Codec.class)
public class LuraWaveCodec
extends AbstractCodec {
    @Parameter(required=false)
    private LuraWaveService luraWaveService;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws FormatException {
        throw new UnsupportedCompressionException("LuraWave compression not supported");
    }

    @Override
    public byte[] decompress(DataHandle<Location> in, CodecOptions options) throws FormatException, IOException {
        byte[] buf = new byte[(int)in.length()];
        in.read(buf);
        return this.decompress(buf, options);
    }

    @Override
    public byte[] decompress(byte[] buf, CodecOptions options) throws FormatException {
        this.checkLuraWaveService();
        BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(buf), 4096);
        try {
            this.luraWaveService.initialize(stream);
        }
        catch (DependencyException e) {
            throw new FormatException("No LuraWave license code was specified.\r\nPlease set one in the lurawave.license system property (e.g., with -Dlurawave.license=XXXX from the command line).", e);
        }
        catch (ServiceException e) {
            throw new FormatException("Invalid license code: ", e);
        }
        catch (IOException e) {
            throw new FormatException(e);
        }
        int w = this.luraWaveService.getWidth();
        int h = this.luraWaveService.getHeight();
        int nbits = 8 * (options.maxBytes / (w * h));
        if (nbits == 8) {
            byte[] image8 = new byte[w * h];
            try {
                this.luraWaveService.decodeToMemoryGray8(image8, -1, 1024, 0);
            }
            catch (ServiceException e) {
                throw new FormatException("Invalid license code: ", e);
            }
            return image8;
        }
        if (nbits == 16) {
            short[] image16 = new short[w * h];
            try {
                this.luraWaveService.decodeToMemoryGray16(image16, 0, -1, 1024, 0, 1, w, 0, 0, w, h);
            }
            catch (ServiceException e) {
                throw new FormatException("Invalid license code: ", e);
            }
            byte[] output = new byte[w * h * 2];
            for (int i = 0; i < image16.length; ++i) {
                Bytes.unpack((long)image16[i], (byte[])output, (int)(i * 2), (int)2, (boolean)true);
            }
            return output;
        }
        throw new FormatException("Unsupported bits per pixel: " + nbits);
    }

    private void checkLuraWaveService() throws FormatException {
        if (this.luraWaveService != null) {
            return;
        }
        throw new MissingLibraryException("The LuraWave decoding library, lwf_jsdk2.6.jar, is required to decode this file.\r\nPlease make sure it is present in your classpath.");
    }
}

