/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackModel;
import fiji.plugin.trackmate.features.FeatureUtils;
import fiji.plugin.trackmate.features.ModelDataset;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.visualization.FeatureColorGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.util.LineUtils;
import org.jfree.data.xy.XYDataset;
import org.jgrapht.graph.DefaultWeightedEdge;

public class SpotCollectionDataset
extends ModelDataset
implements XYDataset {
    private static final long serialVersionUID = 1L;
    private final List<Spot> spots;
    private final Map<Integer, Set<DefaultWeightedEdge>> edgeMap;

    public SpotCollectionDataset(Model model, SelectionModel selectionModel, DisplaySettings ds, String xFeature, List<String> yFeatures, List<Spot> spots, boolean addLines) {
        super(model, selectionModel, ds, xFeature, yFeatures);
        this.spots = spots;
        this.edgeMap = addLines ? SpotCollectionDataset.createEdgeMap(spots, model.getTrackModel()) : null;
    }

    private static Map<Integer, Set<DefaultWeightedEdge>> createEdgeMap(List<Spot> spots, TrackModel trackModel) {
        HashMap<Integer, Set<DefaultWeightedEdge>> edgeMap = new HashMap<Integer, Set<DefaultWeightedEdge>>();
        for (int i = 0; i < spots.size(); ++i) {
            Spot source = spots.get(i);
            HashSet<DefaultWeightedEdge> edges = new HashSet<DefaultWeightedEdge>();
            for (Spot target : spots) {
                if (source.getFeature("FRAME").intValue() > target.getFeature("FRAME").intValue() || !trackModel.containsEdge(source, target)) continue;
                edges.add(trackModel.getEdge(source, target));
            }
            if (edges.isEmpty()) continue;
            edgeMap.put(i, edges);
        }
        return edgeMap;
    }

    public int getItemCount(int series) {
        return this.spots.size();
    }

    @Override
    public String getItemLabel(int item) {
        return this.spots.get(item).getName();
    }

    @Override
    public void setItemLabel(int item, String label) {
        this.spots.get(item).setName(label);
    }

    public String getSeriesKey(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return this.model.getFeatureModel().getSpotFeatureShortNames().get(this.yFeatures.get(series));
    }

    public Number getX(int series, int item) {
        return this.spots.get(item).getFeature(this.xFeature);
    }

    public Number getY(int series, int item) {
        return this.spots.get(item).getFeature((String)this.yFeatures.get(series));
    }

    @Override
    public XYItemRenderer getRenderer() {
        return new MyXYItemRenderer();
    }

    private final class MyXYItemRenderer
    extends XYLineAndShapeRenderer {
        private static final long serialVersionUID = 1L;

        private MyXYItemRenderer() {
        }

        protected void drawPrimaryLine(XYItemRendererState state, Graphics2D g2, XYPlot plot, XYDataset dataset, int pass, int series, int item, ValueAxis domainAxis, ValueAxis rangeAxis, Rectangle2D dataArea) {
            if (SpotCollectionDataset.this.edgeMap == null || !SpotCollectionDataset.this.edgeMap.containsKey(item)) {
                return;
            }
            RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
            PlotOrientation orientation = plot.getOrientation();
            String yFeature = (String)SpotCollectionDataset.this.yFeatures.get(series);
            Spot sourceSpot = SpotCollectionDataset.this.spots.get(item);
            Set<DefaultWeightedEdge> edges = SpotCollectionDataset.this.edgeMap.get(item);
            for (DefaultWeightedEdge edge : edges) {
                boolean visible;
                Spot targetSpot = SpotCollectionDataset.this.model.getTrackModel().getEdgeTarget(edge);
                Double x1 = targetSpot.getFeature(SpotCollectionDataset.this.xFeature);
                Double y1 = targetSpot.getFeature(yFeature);
                if (x1 == null || y1 == null || x1.isNaN() || y1.isNaN()) continue;
                Double x0 = sourceSpot.getFeature(SpotCollectionDataset.this.xFeature);
                Double y0 = sourceSpot.getFeature(yFeature);
                if (x0 == null || y0 == null || x0.isNaN() || y0.isNaN()) continue;
                double transX0 = domainAxis.valueToJava2D(x0.doubleValue(), dataArea, xAxisLocation);
                double transY0 = rangeAxis.valueToJava2D(y0.doubleValue(), dataArea, yAxisLocation);
                double transX1 = domainAxis.valueToJava2D(x1.doubleValue(), dataArea, xAxisLocation);
                double transY1 = rangeAxis.valueToJava2D(y1.doubleValue(), dataArea, yAxisLocation);
                if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) continue;
                if (orientation == PlotOrientation.HORIZONTAL) {
                    state.workingLine.setLine(transY0, transX0, transY1, transX1);
                } else if (orientation == PlotOrientation.VERTICAL) {
                    state.workingLine.setLine(transX0, transY0, transX1, transY1);
                }
                if (!(visible = LineUtils.clipLine((Line2D)state.workingLine, (Rectangle2D)dataArea))) continue;
                this.drawFirstPassShape(g2, pass, series, item, state.workingLine);
            }
        }

        public Paint getItemPaint(int series, int item) {
            Spot spot = SpotCollectionDataset.this.spots.get(item);
            if (SpotCollectionDataset.this.selectionModel != null && SpotCollectionDataset.this.selectionModel.getSpotSelection().contains(spot)) {
                return SpotCollectionDataset.this.ds.getHighlightColor();
            }
            FeatureColorGenerator<Spot> spotColorGenerator = FeatureUtils.createSpotColorGenerator(SpotCollectionDataset.this.model, SpotCollectionDataset.this.ds);
            return spotColorGenerator.color(SpotCollectionDataset.this.spots.get(item));
        }

        public Stroke getItemStroke(int series, int item) {
            Spot spot = SpotCollectionDataset.this.spots.get(item);
            if (SpotCollectionDataset.this.selectionModel != null && SpotCollectionDataset.this.selectionModel.getSpotSelection().contains(spot)) {
                return SpotCollectionDataset.this.selectionStroke;
            }
            return SpotCollectionDataset.this.stroke;
        }

        public LegendItem getLegendItem(int datasetIndex, int series) {
            LegendItem legendItem = super.getLegendItem(datasetIndex, series);
            legendItem.setFillPaint((Paint)Color.BLACK);
            legendItem.setLinePaint((Paint)Color.BLACK);
            legendItem.setOutlinePaint((Paint)Color.BLACK);
            return legendItem;
        }
    }
}

