/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import bdv.util.Bdv;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import java.util.function.Consumer;
import net.imglib2.Interval;
import sc.fiji.labkit.ui.bdv.BdvLayer;
import sc.fiji.labkit.ui.bdv.BdvShowable;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.utils.Notifier;

public class TMBdvLayerLink
implements Holder<BdvStackSource<?>> {
    private final BdvHandle handle;
    private final BdvLayer layer;
    private final Notifier notifier = new Notifier();
    private final Runnable onImageChanged = this::onImageChanged;
    private final Runnable onVisibilityChanged = this::updateBdv;
    private final Consumer<Interval> onRequestRepaint = this::onRequestRepaint;
    private BdvStackSource<?> bdvSource;

    public TMBdvLayerLink(BdvLayer layer, BdvHandle handle) {
        this.handle = handle;
        this.layer = layer;
        BdvOptions options = BdvOptions.options().addTo((Bdv)handle);
        Holder image = layer.image();
        BdvShowable showable1 = (BdvShowable)image.get();
        this.bdvSource = showable1 != null ? showable1.show(layer.title(), options) : null;
        image.notifier().addWeakListener(this.onImageChanged);
        layer.listeners().addWeakListener(this.onRequestRepaint);
        layer.visibility().notifier().addListener(this.onVisibilityChanged);
    }

    private void onImageChanged() {
        BdvShowable showable;
        BdvStackSource<?> source1 = this.bdvSource;
        this.bdvSource = null;
        if (source1 != null) {
            source1.removeFromBdv();
        }
        if ((showable = (BdvShowable)this.layer.image().get()) != null) {
            this.bdvSource = showable.show(this.layer.title(), BdvOptions.options().addTo((Bdv)this.handle));
            this.bdvSource.setActive(((Boolean)this.layer.visibility().get()).booleanValue());
        }
        this.updateBdv();
        this.notifier.notifyListeners();
    }

    private void onRequestRepaint(Interval interval) {
        if (interval == null) {
            this.handle.getViewerPanel().requestRepaint();
        } else {
            this.handle.getViewerPanel().requestRepaint(interval);
        }
    }

    private void updateBdv() {
        if (this.bdvSource != null) {
            try {
                this.bdvSource.setActive(((Boolean)this.layer.visibility().get()).booleanValue());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void set(BdvStackSource<?> value) {
        throw new UnsupportedOperationException();
    }

    public BdvStackSource<?> get() {
        return this.bdvSource;
    }

    public Notifier notifier() {
        return this.notifier;
    }
}

