/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.providers;

import fiji.plugin.trackmate.TrackMateModule;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.log.LogService;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;

public abstract class AbstractProvider<K extends TrackMateModule> {
    private final Class<K> cl;
    protected List<String> keys;
    protected List<String> visibleKeys;
    protected List<String> disabled;
    protected Map<String, K> implementations;

    public AbstractProvider(Class<K> cl) {
        this.cl = cl;
        this.registerModules();
    }

    private void registerModules() {
        Context context = TMUtils.getContext();
        LogService log = (LogService)context.getService(LogService.class);
        PluginService pluginService = (PluginService)context.getService(PluginService.class);
        List infos = pluginService.getPluginsOfType(this.cl);
        this.keys = new ArrayList<String>(infos.size());
        this.visibleKeys = new ArrayList<String>(infos.size());
        this.disabled = new ArrayList<String>(infos.size());
        this.implementations = new HashMap<String, K>();
        for (PluginInfo info : infos) {
            if (!info.isEnabled()) {
                this.disabled.add(info.getClassName());
                continue;
            }
            try {
                TrackMateModule implementation = (TrackMateModule)info.createInstance();
                String key = implementation.getKey();
                this.implementations.put(key, (String)((Object)implementation));
                this.keys.add(key);
                if (!info.isVisible()) continue;
                this.visibleKeys.add(key);
            }
            catch (InstantiableException e) {
                log.error((Object)("Could not instantiate " + info.getClassName()), (Throwable)e);
            }
        }
    }

    public List<String> getKeys() {
        return new ArrayList<String>(this.keys);
    }

    public List<String> getVisibleKeys() {
        return new ArrayList<String>(this.visibleKeys);
    }

    public List<String> getDisabled() {
        return new ArrayList<String>(this.disabled);
    }

    public K getFactory(String key) {
        return (K)((TrackMateModule)this.implementations.get(key));
    }

    public String echo() {
        StringBuilder str = new StringBuilder();
        str.append("Discovered modules for " + this.cl.getSimpleName() + ":\n");
        str.append("  Enabled & visible:");
        if (this.getVisibleKeys().isEmpty()) {
            str.append(" none.\n");
        } else {
            str.append('\n');
            for (String key : this.getVisibleKeys()) {
                str.append("  - " + key + "\t-->\t" + this.getFactory(key).getName() + "\n");
            }
        }
        str.append("  Enabled & not visible:");
        List<String> invisibleKeys = this.getKeys();
        invisibleKeys.removeAll(this.getVisibleKeys());
        if (invisibleKeys.isEmpty()) {
            str.append(" none.\n");
        } else {
            str.append('\n');
            for (String key : invisibleKeys) {
                str.append("  - " + key + "\t-->\t" + this.getFactory(key).getName() + "\n");
            }
        }
        str.append("  Disabled:");
        if (this.getDisabled().isEmpty()) {
            str.append(" none.\n");
        } else {
            str.append('\n');
            for (String cn : this.getDisabled()) {
                str.append("  - " + cn + "\n");
            }
        }
        return str.toString();
    }
}

